;+
; Project     : SOHO - CDS
;
; Name        : SEL_PRINTER
;
; Purpose     : select printer 
;
; Category    : Device, Widgets
;
; Explanation : retrieves a printer name from a selection
;               obtained from PRINTCAPS file
;
; Syntax      : IDL> sel_printer,printer,err=err,status=status
;
; Inputs      : None
;
; Opt. Inputs : None
;
; Outputs     : printer = selected printer name
;
; Opt. Outputs: None
;
; Keywords    : GROUP = widget ID of calling widget
;               STATUS = 0/1 if selection aborted/completed
;               INSTRUCT = instructions for user
;               DEFAULT = default printer selection
;
; Common      : SEL_PRINTER: holds last selected printer name
;
; Restrictions: currently works best for UNIX
;
; Side effects: environment variable PRINTER set to printer name
;
; History     : Version 1,  1-Sep-1995,  D.M. Zarro.  Written
;
; Contact     : DZARRO@SOLAR.STANFORD.EDU
;-


pro sel_printer,printer,group=group,err=err,status=status,$
                default=default,instruct=instruct

common sel_printer,last_choice
err=''

printer='' & desc='' & status=1
def=getenv('PRINTER')
list_printer,printers,desc,err=err
if not exist(last_choice) then last_choice=''
if datatype(default) eq 'STR' then begin
 aa=grep(default,printers,index=index)
 if aa(0) ne '' then begin
  def=printers(index(0)) & last_choice=desc(index(0))
 endif
endif

if printers(0) ne '' then begin
 if strtrim(last_choice,2) eq '' then begin
  last_choice=desc(0)
  def=printers(0)
 endif
 temp = xsel_list(printers+' --- '+desc, group = group, $
                 title = 'Available Printers', $
                 initial=def+' --- '+last_choice,/index,$
                 status = status,/no_remove,subtitle=instruct)
 if status then begin 
  printer=printers(temp) & mklog,'PRINTER',printer 
  last_choice=desc(temp)
 endif
endif else message,'Using default printer',/cont

return & end

