;+
; Project     : SOHO - CDS
;
; Name        : SEND_MAIL
;
; Purpose     : to e-mail a file or array 
;
; Category    : Device
;
; Explanation : checks operating system and spawns the appropriate
;               command.
;
; Syntax      : IDL> send_mail,file,address,array=array
;
;
; Inputs      : FILE = filename to mail
;               ADDRESS = address to send to (e.g., zarro@smmdac)
;
; Opt. Inputs : None
;
; Outputs     : None
;
; Opt. Outputs: None
;
; Keywords    : ERR - error message
;               ARRAY - alternative string array to print
;
; Common      : None
;
; Restrictions: None
;
; Side effects: File deleted when /DEL set
;
; History     : Version 1,  4-Sep-1995,  D.M. Zarro.  Written
;
; Contact     : DZARRO@SOLAR.STANFORD.EDU
;-

pro send_mail,file,address,err=err,array=array

on_error,1
err='' 

;-- check inputs

if datatype(address) ne 'STR' then begin
 err='Enter full name and address (e.g. zarro@smmdac)'
 message,err,/cont
 return
endif

if (datatype(array) eq 'STR') and (datatype(file) eq 'STR') then begin
 err='Cannot simultaneously use file or string array as inputs'
 message,err,/cont
 return
endif

if (datatype(array) ne 'STR') and (datatype(file) ne 'STR') then begin
 err='Enter file or string array to mail'
 message,err,/cont
 return
endif

if datatype(file) eq 'STR' then begin
 chk=loc_file(file,count=count)
 if count eq 0 then begin
  err='Cannot locate '+file
  message,err,/cont
  return
 endif
endif

;-- send array or file

del=0
if datatype(array) eq 'STR' then begin
 del=1
 str2file,array,temp
endif else temp=file

;-- spawn mail

if os_family() eq 'vms' then cmd='mail '+temp+' '+ address else $
 cmd='mail '+address+' < '+temp

dprint,cmd
espawn,cmd,out

if out(0) ne '' then begin
 err=out(0)
 message,err,/cont
endif

;-- delete temporary file

if del then begin
 openr,lun,temp,/get_lun,/del
 close,lun & free_lun,lun
endif

return & end


