;---------------------------------------------------------------------------
; Document name: valid_time.pro
; Created by:    Liyun Wang, GSFC/ARC, May 5, 1995
;
; Last Modified: Fri May  5 17:11:52 1995 (lwang@achilles.nascom.nasa.gov)
;---------------------------------------------------------------------------
;
FUNCTION valid_time, time, error
;+
; PROJECT:
;       SOHO - CDS
;
; NAME:	
;       VALID_TIME()
;
; PURPOSE:
;       To test if the given time has the valid format
;
; EXPLANATION:
;       
; CALLING SEQUENCE: 
;       Result = valid_time(time [, err])
;
; INPUTS:
;       time - Any date/time format
;
; OPTIONAL INPUTS: 
;       None.
;
; OUTPUTS:
;       Result - 1 if the time format is valid, 0 otherwise
;
; OPTIONAL OUTPUTS:
;       ERROR  - A string scalar containing error message. If the time format
;                is correct, ERROR will be a null string
;
; KEYWORD PARAMETERS: 
;       None.
;
; CALLS:
;       ANYTIM2UTC
;
; COMMON BLOCKS:
;       None.
;
; RESTRICTIONS: 
;       None.
;
; SIDE EFFECTS:
;       None.
;
; CATEGORY:
;       
; PREVIOUS HISTORY:
;       Written May 5, 1995, Liyun Wang, GSFC/ARC
;
; MODIFICATION HISTORY:
;       Version 1, created, Liyun Wang, GSFC/ARC, May 5, 1995
;
; VERSION:
;       Version 1, May 5, 1995
;-
;
   ON_ERROR, 2
   error = ''
   IF N_ELEMENTS(time) EQ 0 THEN BEGIN
      error = 'Syntax: aa = valid_time(time)'
      MESSAGE, error, /cond
      RETURN, 0
   ENDIF
   temp = anytim2utc(time, err = error)
   IF error NE '' THEN RETURN, 0 ELSE RETURN, 1
END

;---------------------------------------------------------------------------
; End of 'valid_time.pro'.
;---------------------------------------------------------------------------
