;+
; Project     :	SDAC
;
; Name        :	ADD_TAG
;
; Purpose     :	add a tag to a structure
;
; Explanation :	
;
; Use         : NEW_STRUCT=ADD_TAG(STRUCT,TAG,TAG_NAME)
;
; Inputs      :	STRUCT = input structure (array or scalar)
;             : TAG_VALUE = tag variable to add 
;             : TAG_NAME = tag name 
;
; Opt. Inputs :	None.
;
; Outputs     :	NEW_STRUCT = new structure
;
; Opt. Outputs:	None.
;
; Keywords    :	NAME = new name for structure
;               INDEX = index where to append new tag [def = last]
;
; Restrictions:	Cannot add more than one tag at a time
;
; Side effects:	None.
;
; Category    :	Structure handling
;
; Prev. Hist. :	None.
;
; Written     :	Dominic Zarro (ARC)
;
; Version     :	Version 1.0, 7 November 1994
;-

function add_tag,struct,tag_value,tag_name,name=name,index=index

common add_tag,xxx
on_error,1

mess='syntax --> NEW_STRUCT=ADD_TAG(STRUCT,TAG_VALUE,TAG_NAME)'
if not exist(tag_value) then begin
 message,mess,/cont
 if exist(struct) then return,struct else return,0
endif

;-- no tag name was entered

if datatype(tag_name) eq 'STR' then tname=tag_name else tname=''
tname=strtrim(tname(0),2)
if tname eq '' then begin
 message,'tag name cannot be blank -- using NONAME',/cont
 tname='NONAME'
endif

if n_elements(tname) ne 1 then begin
 message,'restricted to adding one tag at a time',/cont
 if exist(struct) then return,struct else return,0
endif

if datatype(name) ne 'STR' then sname='' else sname=name
sname=strtrim(sname,2) 
if chk_struct_name(sname,/verb) eq 0 then return,struct 

;-- no structure was entered, so create it

tname=strupcase(tname)
if sname ne '' then sname=sname+',' else sname=''

if datatype(struct) ne 'STC' then begin
 status=execute('new_struct={'+sname+tname+':tag_value}')
 if status then return,new_struct else return,-1
endif

;-- does tag already exist

if tag_exist(struct,tname) then begin
 message,tname+' tag already exists',/cont
 return,struct
endif

;-- determine location of added tag

new_struct=0
tags=tag_names(struct)
ntags=n_elements(tags)
if n_elements(index) eq 0 then index=ntags-1
index= -1 > index < (ntags-1)
new_val=tname+':tag_value,$'
prepend=(index eq -1)

if sname ne '' then str_start='temp_struct = {'+sname+'$' else $
                    str_start='temp_struct = {$'

for k=0,n_elements(struct)-1 do begin
 str=str_start
 s=struct(k)

 for i=0,ntags-1 do begin
  val=tags(i)+':s.('+string(i)+'),$'
  prepend=(i eq 0) and (index eq -1)
  if prepend then val=[new_val,val] 
  append=(i eq index)
  if append then val=[val,new_val]
  str=[str,val]
 endfor

;-- check if total string length less than EXECUTE limit

 ex_max=120
 np=n_elements(str)
 comma=strpos(str(np-1),',')
 if comma gt -1 then str(np-1)=strmid(str(np-1),0,comma)
 str(np-1)=str(np-1)+'}'
 new=strarr(np)
 for i=0,np-1 do new(i)=strep(str(i),'$','',/all) 
 new=strcompress(new,/rem)
 total_len=total(strlen(new))
 if total_len lt ex_max then begin
  status=execute(arr2str(new,delim=''))
 endif else begin

;-- otherwise write to a temporary function file, compile it, run it, and delete it;
;   this solves the maximum string length limit in EXECUTE

  state=str
  home=getenv('HOME')
  if strlowcase(!version.os) eq 'vms' then delim=',' else delim=':'
  timestamp=strtrim(strcompress(systime(0),/rem),2)
  remchar,timestamp,':'
  remchar,timestamp,'-'
  extra=strtrim(string(long(randomu(xxx)*10000)),2)
  temp_funct='s'+strmid(timestamp,8,6)+extra
  temp_file=strtrim(concat_dir(home,temp_funct+'.pro'),2)
  openw,lun,temp_file,/get_lun
  printf,lun,'function '+temp_funct+',s,tag_value'
  printf,lun,'           '
  for j=0,np-1 do printf,lun,state(j)
  printf,lun,'           '
  printf,lun,'return,temp_struct & end'
  close,lun & free_lun,lun
  old_path=!path
  !path=home+delim+!path
  qsave=!quiet
  !quiet=1
  temp_struct=call_function(temp_funct,s,tag_value)
  !quiet=qsave
  !path=old_path
  status=1
  openr,lun,temp_file,/del,/get_lun
  close,lun & free_lun,lun
 endelse
 if status then new_struct=concat_struct(new_struct,temp_struct)
endfor

return,new_struct & end


