;+
; Project     : SOHO - CDS     
;                   
; Name        : ARR2STR()
;               
; Purpose     : Convert an array to a delimited string.
;               
; Explanation : 
;               
; Use         : IDL> s = arr2str(array,'-')
;                    s = arr2str(array,delim='-')
;    
; Inputs      : arr  -  input data array which is to be converted
;                       to a simple string.
;               
; Opt. Inputs : delim - an alternative positional parameter to specify the
;                       delimiter.
;               
; Outputs     : Function returns a simple string using the delimiter to 
;               separate the elements of the original array.
;               
; Opt. Outputs: 
;               
; Keywords    : delimiter  -  specify the delimiter to be used, default 
;                             delimiter is ','
;		trim	   -  If set, call STRTRIM when converting to string
;		compress   -  If set, call STRCOMPRESS after converting
;
; Calls       :
;               
; Restrictions: None
;               
; Side effects: None
;               
; Category    : Util, string
;               
; Prev. Hist. : Yohkoh routine by S Freeland.
;
; Written     : CDS version by C D Pike, RAL, 6 Sept 93
;               
; Modified    : Version 2, William Thompson, GSFC, 15 June 1995
;			Added /TRIM keyword to be compatible with Yohkoh
;			version.  Added /COMPRESS keyword
;
; Version     : Version 2, 15 June 1995
;-            

function arr2str, starray, delim, delimiter=delimiter, trim=trim,	$
	compress=compress

;
;force a return to caller on error
;
on_error, 2      

;
;  delimiter specified as positional parameter
;
if n_params() eq 2 then delimiter = delim

;
;  use default delimiter
;
if (n_elements(delimiter) eq 0) then delimiter=','

;
;  clean up array
;
strings=string(starray)
if (keyword_set(trim)) then strings=(strtrim(string(starray),2))
string=strings(0)

;
;  concatenate elements with required delimiter
;
for i=1,n_elements(starray)-1 do string = string + delimiter + strings(i)
if keyword_set(compress) then string=strcompress(string)

return,string

end
