function Bsort, Array, Asort, INFO=info, REVERSE = rev
;+
; Project     :	SOHO - CDS
;
; Name        :	
;	BSORT
; Purpose     :	
;	Sorts data into ascending order.
; Explanation :	
;	Function to sort data into ascending order, like a simple bubble sort.
;	original subscript order is maintained when values are equal (FIFO).
;	(This differs from the IDL SORT routine alone, which may rearrange 
;	order for equal values)
;
; Use         :	
;	result = bsort( array, [ asort, /INFO, /REVERSE ] )
;
; Inputs      :	
;	Array - array to be sorted
;
; Opt. Inputs :	None.
;
; Outputs     :	
;	result - sort subscripts are returned as function value
;
; Opt. Outputs:	
;	Asort - sorted array
;
; Keywords    :	
;       /REVERSE - if this keyword is set, and non-zero, then data is sorted
;                 in descending order instead of ascending order.
;	/INFO = optional keyword to cause brief message about # equal values.
;
; Calls       :	None.
;
; Common      :	None.
;
; Restrictions:	None.
;
; Side effects:	None.
;
; Category    :	Utilities, Array
;
; Prev. Hist. :	
;	written by F. Varosi Oct.90:
;	uses WHERE to find equal clumps, instead of looping with IF ( EQ ).
;	compatible with string arrays, test for degenerate array 
;	20-MAY-1991	JKF/ACC via T AKE- return indexes if the array to 
;			be sorted has all equal values.
;	Aug - 91  Added  REVERSE keyword   W. Landsman      
;
; Written     :	F. Varosi, GSFC, October 1990
;
; Modified    :	Version 1, William Thompson, GSFC, 29 March 1994
;			Incorporated into CDS library
;		Version 2, William Thompson, GSFC, 3 August 1994
;			Incorporated change by W. Landsman to always return
;			type LONG.
;		Version 3, William Thompson, GSFC, 15 June 1995
;			Merged with Yohkoh version.  Added change by Mons
;			Morrison 24-Sep-1991 to set ASORT to ARRAY when only
;			one element.
;
; Version     :	Version 3, 15 June 1995
;-
;
	N = N_elements( Array )
	if N lt 1 then begin
		print,'Input to BSORT must be an array'
		return, [0L]
 	   endif
	if N lt 2 then begin
	    asort = array	;MDM added 24-Sep-91
	    return,[0L]    ;Only 1 element
	end
;
; sort array (in descending order if REVERSE keyword specified )
;
	subs = sort( Array )
        if keyword_set( REV ) then subs = rotate(subs,5)  
	Asort = Array(subs)
;
; now sort subscripts into ascending order
; when more than one Asort has same value
;
	     weq = where( (shift( Asort, -1 ) eq Asort) , Neq ) 

	if keyword_set( info ) then $
		message, strtrim( Neq, 2 ) + " equal values Located",/CON,/INF

	if (Neq EQ n) then return,lindgen(n) ;Array is degenerate equal values

	if (Neq GT 0) then begin

		if (Neq GT 1) then begin	      ;find clumps of equality

			wclump = where( (shift( weq, -1 ) - weq) GT 1, Nclump )
			Nclump = Nclump + 1

		  endif else Nclump = 1

		if (Nclump LE 1) then begin
			Clump_Beg = 0
			Clump_End = Neq-1
		  endif else begin
			Clump_Beg = [0,wclump+1]
			Clump_End = [wclump,Neq-1]
		   endelse

		weq_Beg = weq( Clump_Beg )		;subscript ranges
		weq_End = weq( Clump_End ) + 1		; of Asort equalities.

		if keyword_set( info ) then message, strtrim( Nclump, 2 ) + $
				" clumps of equal values Located",/CON,/INF

		for ic = 0L, Nclump-1 do begin		;sort each clump.

			subic = subs( weq_Beg(ic) : weq_End(ic) )
		        subs( weq_Beg(ic) ) = subic( sort( subic ) )
		  endfor

		if N_params() GE 2 then Asort = Array(subs)	;resort array.
	   endif

return, subs
end
