;+
; Project     : SOHO - CDS
;
; Name        : FREE_POINTER()
;
; Purpose     : to free a pointer variable
;
; Category    : Help
;
; Explanation : removes a pointer variable.
;               Pointer variable can be an unrealized WIDGET or HANDLE.
;
; Syntax      : IDL> free_pointer(pointer)
;
; Inputs      :  POINTER = pointer variable
;
; Opt. Inputs : None
;
; Outputs     : None
;
; Opt. Outputs: None
;
; Keywords    : None
;
; Common      : None
;
; Restrictions: POINTER becomes invalid
;
; Side effects: None
;
; History     : Version 1,  1-Sep-1995,  D.M. Zarro.  Written
;
; Contact     : DZARRO@SOLAR.STANFORD.EDU
;-

pro free_pointer,pointer

on_error,1

;-- check if an unrealized widget id is being used as a pointer
;-- if so, then kill it and return

if xalive(pointer) then begin
 if not widget_info(pointer,/realized) then begin
  xkill,pointer
  return
 endif
endif

;-- if we got this far, then it's probably a handle

if exist(pointer) then begin
 if call_function('handle_info',pointer,/valid_id) then handle_free,pointer
endif

return & end
