;+
; Project     : SOHO - CDS
;
; Name        : GET_CALLER(WIDGET_ID)
;
; Purpose     : to get name of calling program that created a widget ID.
;
; Category    : Widgets
;
; Explanation : uses WIDGET_INFO to determine handler for WIDGET_ID
;
; Syntax      : IDL> caller = get_caller(widget_id)
;
; Inputs      : WIDGET_ID = widget id 
;
; Opt. Inputs : None
;
; Outputs     : Calling program that created WIDGET_ID 
;               (blank string if undefined)
;
; Opt. Outputs: None
;
; Keywords    : None
;
; Common      : None
;
; Restrictions: WIDGET_ID should be a main base
;
; Side effects: None.
;
; History     : Version 1,  22-Sep-1995,  D.M. Zarro.  Written
;
; Contact     : DZARRO@SOLAR.STANFORD.EDU
;-
    
function get_caller,widget_id
caller=''
if not xalive(widget_id) then return,caller
event_pro=strlowcase(strtrim(widget_info(widget_id,/event_pro),2))
event_fun=strlowcase(strtrim(widget_info(widget_id,/event_fun),2))
if event_pro ne '' then event_han=event_pro
if event_fun ne '' then event_han=event_fun
if event_han ne '' then begin
 clook=strpos(event_han,'_event')
 if clook gt -1 then caller=strmid(event_han,0,clook)
endif
return,caller & end
     
