;+
; Project     :	SDAC
;
; Name        : GET_CENT_OFF
;
; Purpose     : determine pixel offsets for centering widget bases
;
; Use         : OFFSETS=GET_CENT_OFF(WBASE)
;
; Inputs      : WBASE = widget base id
;
; Opt. Inputs : PARENT = ID of parent widget relative to which the
;                       offset values are calculated
;
; Outputs     : OFFSETS=[XOFF,YOFF]
;
; Opt. Outputs: None.
;
; Keywords    : VALID = 1 if valid offsets found, 0 otherwise
;               WSIZE = [xsize,ysize] of WBASE
;               CENTER = center relative to main screen
;
; Explanation : 
;               Useful for centering pop up text widgets.
;               For example: 
;               if parent base is defined as w1, then
;               widget_control,w2,/realize,tlb_set_xoff=xoff,tlb_set_yoff=yoff
;               will center w2 within w1.
;
; Calls       : None.
;
; Common      : None.
;
; Restrictions: WBASE must be valid otherwise [-1,-1] is returned
;
; Side effects: None.
;
; Category    : Widgets
;
; Prev. Hist. : None.
;
; Written     :	Zarro (ARC/GSFC) 17 April 1995
;-

function get_cent_off,wbase,parent,valid=valid,wsize=wsize,center=center

valid=0
offsets=[-1,-1]
center=keyword_set(center)

if not xalive(wbase) then return,offsets

if xalive(parent) and (not center) then $
 widget_control,parent,tlb_get_offset=goff,tlb_get_size=gsize else $
  device,get_screen_size = gsize

widget_control,wbase,tlb_get_size=wsize,/realize

xoff=((gsize(0)-wsize(0))/2) > 0.
yoff=((gsize(1)-wsize(1))/2) > 0.

if n_elements(goff) ne 0 then begin
 xoff=(goff(0)+xoff)
 yoff=(goff(1)+yoff)
endif

valid=1

return,[xoff,yoff] & end


