;+
; Project     : SOHO - CDS
;
; Name        : GET_POINTER()
;
; Purpose     : to get a pointer value from a pointer variable
;
; Category    : Help
;
; Explanation : retrieves a pointer value from a pointer variable.
;               Pointer variable can be an unrealized widget or handle.
;
; Syntax      : IDL> value = get_pointer(pointer)
;
; Inputs      : POINTER = pointer variable
;
; Opt. Inputs : None
;
; Outputs     : Value associated with POINTER
;
; Opt. Outputs: None
;
; Keywords    : NOCOPY   -  do not make internal copy of value
;
; Common      : None
;
; Restrictions: POINTER must be defined via MAKE_POINTER
;
; Side effects: memory value of POINTER is removed when /NO_COPY set
;
; History     : Version 1,  1-Sep-1995,  D.M. Zarro.  Written
;
; Contact     : DZARRO@SOLAR.STANFORD.EDU
;-

function get_pointer,pointer,no_copy=no_copy

on_error,1

;-- check if pointer is an unrealized widget

if xalive(pointer) then begin
 if not widget_info(pointer,/realized) then begin
  widget_control,pointer,get_uvalue=value,no_copy=keyword_set(no_copy)
  return,value
 endif
endif

;-- check if pointer is a valid handle 

if exist(pointer) then begin
 if call_function('handle_info',pointer,/valid_id) then begin
  handle_value,pointer,value,no_copy=keyword_set(no_copy)
  return,value
 endif
endif

message,'input pointer is invalid',/cont

return,value & end
