;---------------------------------------------------------------------------
; Document name: get_uniq_list.pro
; Created by:    Liyun Wang, GSFC/ARC, May 22, 1995
;
; Last Modified: Wed May 24 11:25:01 1995 (lwang@achilles.nascom.nasa.gov)
;---------------------------------------------------------------------------
;
FUNCTION get_uniq_list, str_array, original=original
;+
; PROJECT:
;       SOHO - CDS
;
; NAME:	
;       GET_UNIQ_LIST()
;
; PURPOSE:
;       Extract uniq list of string values from a string array
;
; EXPLANATION:
;       This routine examines all elements of a string array, sorts
;       these values, gets rid of repeated values and return a new
;       string array with uniq values in a sorted order.
;
; CALLING SEQUENCE: 
;       Result = get_uniq_list(str_array)
;
; INPUTS:
;       STR_ARRAY - String array to work with
;
; OPTIONAL INPUTS: 
;       ORIGINAL - Original list
;
; OUTPUTS:
;       RESULT - Extracted string from STR_ARRAY or from input
;
; OPTIONAL OUTPUTS:
;       None.
;
; KEYWORD PARAMETERS: 
;       None.
;
; CALLS:
;       GREP, DATATYPE
;
; COMMON BLOCKS:
;       None.
;
; RESTRICTIONS: 
;       None.
;
; SIDE EFFECTS:
;       None.
;
; CATEGORY:
;       
; PREVIOUS HISTORY:
;       Written May 22, 1995, Liyun Wang, GSFC/ARC
;
; MODIFICATION HISTORY:
;       Version 1, created, Liyun Wang, GSFC/ARC, May 22, 1995
;
; VERSION:
;       Version 1, May 22, 1995
;-
;
   ON_ERROR, 2
   
   IF datatype(str_array) NE 'STR' THEN BEGIN
      MESSAGE, 'Invalid input data type.', /cont
      RETURN, -1
   ENDIF
   
   IF N_ELEMENTS(original) NE 0 THEN str_array = [str_array, original]
   str_array = STRTRIM(str_array,2)
   ii = WHERE(str_array NE '')
   IF ii(0) NE -1 THEN str_array = str_array(ii)
   IF N_ELEMENTS(str_array) GT 1 THEN BEGIN
      uniq_idx = uniq(str_array, SORT(str_array))
      str_array = str_array(uniq_idx)
   ENDIF
   RETURN, str_array
END

;---------------------------------------------------------------------------
; End of 'get_uniq_list.pro'.
;---------------------------------------------------------------------------
