;----------------------------------------------------------------------
; Document name: grep.pro
; Created by:    Liyun Wang, GSFC/ARC, December 15, 1994
;
; Last Modified: Wed Jul 26 17:46:25 1995 (lwang@achilles.nascom.nasa.gov)
;----------------------------------------------------------------------
;
FUNCTION GREP, str, strarray, sensitive=sensitive, exact=exact, index=index
;+
; PROJECT:
;       SOHO - CDS
;
; NAME:
;       GREP()
;
; PURPOSE:
;       Search for string through a string array (cf grep in Perl)
;
; EXPLANATION:
;
; CALLING SEQUENCE:
;       Result = GREP(str, strarray)
;
; INPUTS:
;       STR      - Target string to be searched for
;       STRARRAY - String array over which the string is seached
;
; OPTIONAL INPUTS:
;       None.
;
; OUTPUTS:
;       Result   - String array of elements from STRARRAY which contains
;                  the searched string STR. A null string will be returned if
;                  no elements in STRARRAY match STR.
;
; OPTIONAL OUTPUTS:
;       INDEX    - Index of elements in STRARRAY which match the target string
;
; KEYWORD PARAMETERS:
;       SENSITIVE  - Make the search pattern case sensitive, if set
;       EXACT      - Requires exact match (instead of substring match)
;
; CALLS:
;       DATATYPE
;
; COMMON BLOCKS:
;       None.
;
; RESTRICTIONS:
;       None.
;
; SIDE EFFECTS:
;       None.
;
; CATEGORY:
;
; PREVIOUS HISTORY:
;       Written December 15, 1994, Liyun Wang, GSFC/ARC
;
; MODIFICATION HISTORY:
;       Version 2, Liyun Wang, GSFC/ARC, January 20, 1995
;          Added the INDEX keyword
;       Version 3, July 26, 1995, Liyun Wang, GSFC/ARC
;          Made it return a null string if error occurs (instead of
;             stopping the program.
;
; VERSION:
;       Version 3, July 26, 1995
;-
;
   ON_ERROR, 2
   index = -1
   IF datatype(str) NE 'STR' OR datatype(strarray) NE 'STR' THEN BEGIN
      MESSAGE, 'Input parameter must be of string type.', /cont
      RETURN, ''
   ENDIF
   
   nn = N_ELEMENTS(strarray)
   aa = strarray
   a = str
   index = -1
   IF NOT KEYWORD_SET(sensitive) THEN BEGIN
      aa = STRUPCASE(aa)
      a = STRUPCASE(a)
   ENDIF

   IF KEYWORD_SET(exact) THEN BEGIN
      FOR i = 0, nn-1 DO BEGIN
         IF (a EQ aa(i)) THEN BEGIN
            IF N_ELEMENTS(ccc) EQ 0 THEN BEGIN
               ccc = strarray(i) 
               index = i
            ENDIF ELSE BEGIN
               index = [index, i]
               ccc = [ccc, strarray(i)]
            ENDELSE
         ENDIF
      ENDFOR
   ENDIF ELSE BEGIN
      FOR i = 0, nn-1 DO BEGIN
         id = STRPOS(aa(i),a)
         IF (id GE 0) THEN BEGIN
            IF N_ELEMENTS(ccc) EQ 0 THEN BEGIN
               ccc = strarray(i)
               index = i
            ENDIF ELSE BEGIN
               ccc = [ccc, strarray(i)]
               index = [index, i]
            ENDELSE
         ENDIF
      ENDFOR
   ENDELSE
   IF N_ELEMENTS(ccc) NE 0 THEN RETURN, ccc ELSE RETURN, ''
END

;----------------------------------------------------------------------
; End of 'grep.pro'.
;----------------------------------------------------------------------
