;+
; Project     :	SDAC
;
; Name        :	JOIN_STRUCT
;
; Purpose     :	join two structures by appending tags
;
; Explanation :	
;
; Use         : NEW_STRUCT=JOIN_STRUCT(S1,S2)
;
; Inputs      :	S1,S2 input structures
;
; Opt. Inputs :	None.
;
; Outputs     :	NEW_STRUCT = new structure
;
; Opt. Outputs:	None.
;
; Keywords    :	NAME = new name for structure
;
; Calls       :	ADD_TAG
;
; Common      :	None.
;
; Restrictions:	Input structures must have same dimension
;
; Side effects:	None.
;
; Category    :	Structure handling
;
; Prev. Hist. :	None.
;
; Written     :	Dominic Zarro (ARC)
;
; Version     :	Version 1.0, 7 November 1994
;-

function join_struct,s1,s2,name=name      

on_error,1

mess='syntax --> NEW_STRUCT=JOIN_STRUCT(S1,S2,NAME=NAME)'

eflag=0
if datatype(s2) ne 'STC' then eflag=1
if (n_elements(s1) ne 0) and $
   ((datatype(s1) ne 'STC') and (datatype(s2) ne 'STC')) then eflag=1

if eflag then begin
 message,mess,/cont
 return,0
endif

if (n_elements(s1) ne 0) and (n_elements(s1) ne n_elements(s2)) then begin
 message,'input structures must have same dimensions',/cont
 return,0
endif


nstruct=n_elements(s1)
tags=tag_names(s2)
ntags=n_elements(tags)

if datatype(name) ne 'STR' then sname='' else sname=name
sname=strtrim(sname,2) 

if nstruct eq 0 then begin
 temp_s2=s2
 for i=0,ntags-1 do begin
  if i eq (ntags-1) then tname=sname else tname=''
  temp_s1=add_tag(temp_s1,temp_s2.(i),tags(i),name=tname)
 endfor
 new_struct=temp_s1 
endif else begin
 for k=0,nstruct-1 do begin
  temp_s1=s1(k)
  temp_s2=s2(k)
  for i=0,n_elements(tags)-1 do begin
   if i eq (ntags-1) then tname=sname else tname=''
   temp_s1=add_tag(temp_s1,temp_s2.(i),tags(i),name=tname)
  endfor
  new_struct=concat_struct(new_struct,temp_s1)
 endfor
endelse

return,new_struct & end

