;+
; Project     : SOHO - CDS
;
; Name        : MAKE_POINTER
;
; Purpose     : to make a pointer variable
;
; Category    : Help
;
; Explanation : creates a pointer variable.
;               Pointer variable can be an unrealized WIDGET or HANDLE.
;
; Syntax      : IDL> make_pointer,pointer
;
; Inputs      : None
;
; Opt. Inputs : None
;
; Outputs     : POINTER = pointer variable
;
; Opt. Outputs: None
;
; Keywords    : WIDGET -  create unrealized widget ID instead of a HANDLE
;
; Common      : None
;
; Restrictions: HANDLE is only used for IDL version > 3.6
;
; Side effects: None
;
; History     : Version 1,  1-Sep-1995,  D.M. Zarro.  Written
;
; Contact     : DZARRO@SOLAR.STANFORD.EDU
;-

pro make_pointer,pointer,widget=widget

on_error,1

vers=float(strmid(!version.release,0,3))

;-- create unrealized widget if IDL version le 3.6 or /WID set

if (vers lt 3.6) or keyword_set(widget) then pointer=widget_base() else $
  pointer=call_function('handle_create')
 
return

end
