;+
; Project     :	SDAC
;
; Name        :	MATCH_STRUCT
;
; Purpose     :	check if two structures are identical
;
; Explanation :	cross-checks type and value of each field
;
; Use         : STATUS=MATCH_STRUCT(STRUCT1,STRUCT2)
;
; Inputs      :	S1, S2 = input structures
;
; Opt. Inputs :	None.
;
; Outputs     :	STATUS = 1/0 is input structure are/are not identical
;
; Opt. Outputs:	None.
;
; Keywords    :	TAG_ONLY = set to check if only tags are the same
;               FLOATING = do checks in floating point
;               BLANK = treat string blanks as valid characters
;               TYPE_ONLY = set to check if datatype of each tag
;               is the same (values are not checked)
;
; Calls       :	DATATYPE
;
; Common      :	None.
;
; Restrictions:	None.
;
; Side effects:	None.
;
; Category    :	Structure handling
;
; Prev. Hist. :	None.
;
; Written     :	Dominic Zarro (ARC/GSFC)
;
; Modified    : To handle arrays of strings.  CDP, 27-Feb-95
;               Removed redundant string check. DMZ, 1-March-95
;
; Version     :	Version 3, 1-March-95
;
;-

function match_struct,s1,s2,tags_only=tags_only,floating=floating,blank=blank,$
                            type_only=type_only

on_error,1

status=0

if (datatype(s1) ne 'STC') or (datatype(s2) ne 'STC') then begin
 message,'syntax --> STATUS=MATCH_STRUCT(STRUCT1,STRUCT2)',/contin
 return,status
endif

;-- check that input structures have same number of tags

t1=tag_names(s1) & t2=tag_names(s2)
if n_elements(t1) ne n_elements(t2) then return,status

match,t1,t2,a,b
if (a(0) eq -1) or (b(0) eq -1) then return,status

if keyword_set(tags_only) then return,1

;-- check if datatype match

if keyword_set(type_only) then begin
 return,match_struct(clear_struct(s1(0)),clear_struct(s2(0)))
endif

;-- check that everything else matches

for i=0,n_elements(t1)-1 do begin

 if t1(i) ne t2(i) then return,0

 f1=s1.(i) & f2=s2.(i)

 if datatype(f1) ne datatype(f2) then return,0

;-- have to do the following in case there are small differences
;  due to round-off

 dtype=datatype(f1)
 if (dtype ne 'STR') and (dtype ne 'STC') and keyword_set(floating) then begin
  f1=float(f1) & f2=float(f2)
 endif

 if (dtype eq 'STR') and not keyword_set(blank) then begin
  f1=strtrim(f1,2) & f2=strtrim(f2,2)
 endif

 case 1 of

;-- structure case

  datatype(f1) eq 'STC' : begin   
   status=match_struct(f1,f2,tags_only=tags_only,floating=floating,blank=blank)
  end

  else: begin
   clook=where( (f2 eq f1) eq 1,cnt)
   status=(cnt eq n_elements(f1))
  end

 endcase

 if total(status) ne n_elements(status) then return,0b
endfor

;-- made it this far, so must be ok

status=1


return,fix(status) & end

