;+
; Project     :	SOHO - CDS
;
; Name        :	MAX_TAG
;
; Purpose     :	find max dimension of a tag in a structure
;
; Explanation :
;
; Use         : MAX=MAX_TAG(STRUCT)
;
; Inputs      :	STRUCT = input structure
;
; Opt. Inputs :	None.
;
; Outputs     :	MAX = max dimension of tags
;
; Opt. Outputs:	None.
;
; Keywords    :	NEST = check nested structure dimensions only
;
; Calls       :	None.
;
; Common      :	None.
;
; Restrictions:	None.
;
; Side effects:	None.
;
; Category    :	Structure handling
;
; Prev. Hist. :	None.
;
; Written     :	Dominic Zarro (ARC)
;
; Version     :	Version 1.0, 22 May 1995
;-

function max_tag,struct,nest=nest

if datatype(struct) ne 'STC' then begin
 message,'syntax --> MAX = MAX_TAG(STRUCT)',/cont
 return,0
endif

tags=tag_names(struct)
nest=keyword_set(nest)

ndim=0
temp=struct(0)
check_it=1
for i=0,n_elements(tags)-1 do begin
 if nest then check_it=datatype(temp.(i)) eq 'STC'
 if check_it then ndim=n_elements(temp.(i)) > ndim
endfor

return,ndim & end

