	FUNCTION PRODUCT, ARRAY
;+
; Project     : SOHO - CDS
;
; Name        : 
;	PRODUCT()
; Purpose     : 
;	Calculates the product of all the elements of an array.
; Explanation : 
;	Calculates the product of all the elements of an array--the
;	multiplicative equivalent of total.
; Use         : 
;	Result = PRODUCT(ARRAY)
; Inputs      : 
;	ARRAY	= Array of elements to multiply together.  For instance, ARRAY
;		  could contain the dimensions of another array--then
;		  PRODUCT(ARRAY) would be the total number of elements of that
;		  other array.
; Opt. Inputs : 
;	None.
; Outputs     : 
;	The result of the function is the total product of all the elements of
;	ARRAY.
; Opt. Outputs: 
;	None.
; Keywords    : 
;	None.
; Calls       : 
;	None.
; Common      : 
;	None.
; Restrictions: 
;	ARRAY must be a numerical type.
; Side effects: 
;	The result will always be of at least floating point type.
; Category    : 
;	Utilities, Arrays.
; Prev. Hist. : 
;	William Thompson, Feb. 1992.
; Written     : 
;	William Thompson, GSFC, February 1992.
; Modified    : 
;	Version 1, William Thompson, GSFC, 12 April 1993.
;		Incorporated into CDS library.
; Version     : 
;	Version 1, 12 April 1993.
;-
;
	ON_ERROR,2
;
;  Check the number of parameters.
;
	IF N_PARAMS() NE 1 THEN MESSAGE,'Syntax:  Result = PRODUCT(ARRAY)'
;
;  Check the type of ARRAY.
;
	SZ = SIZE(ARRAY)
	TYPE = SZ(SZ(0)+1)
	IF TYPE EQ 0 THEN MESSAGE,'ARRAY not defined'
	IF TYPE EQ 7 THEN MESSAGE,'Operation illegal with string arrays'
	IF TYPE EQ 8 THEN MESSAGE,'Operation illegal with structures'
;
;  Calculate the product.
;
	RESULT = 1.
	FOR I=0,N_ELEMENTS(ARRAY)-1 DO RESULT = RESULT * ARRAY(I)
;
	RETURN,RESULT
	END
