FUNCTION read_key, wait
;+
; Project     :	SOHO - CDS
;
; Name        :	
;	READ_KEY
;
; Purpose     :	
;	Returns ASCII equivalent of keystroke.
;
; Explanation :	
;	Reads a keystroke and return its ASCII equivalent, unless an
;	ESCAPE sequence was produced.  In that case, if the sequence is
;	recognized, a code is returned.
;
; Use         :	
;	key = READ_KEY(Wait)
;
; Inputs      :	
;	Wait  -  The wait flag.  If non-zero, execution is halted until a
;	         key is struck.  If zero, execution returns immediately and
;	         a zero is returned if there was no keystroke waiting in the
;	         keyboard buffer.  If not specified, zero is assumed.
;
; Opt. Inputs :	None.
;
; Outputs     :	
;	Returned - The key struck.  The ASCII code for non-escape sequences.
;	           Escape sequence equivalents:
;			Up Arrow     --  128
;			Down Arrow   --  130
;			Left Arrow   --  129
;			Right Arrow  --  131
;			Else         --    0
;
;	The return value is a byte value.
;
; Opt. Outputs:	None.
;
; Keywords    :	None.
;
; Calls       :	None.
;
; Common      :	None.
;
; Restrictions:	None.
;
; Side effects:	None.
;
; Category    :	Utilities, user_interface.
;
; Prev. Hist. :	
;	Written by Michael R. Greason, STX, 22 June 1990.
;	Rewritten for a SUN workstation.  MRG, STX, 23 August 1990.
;
; Written     :	Michael R. Greason, STX, 22 June 1990.
;
; Modified    :	Version 1, William Thompson, GSFC, 30 March 1995
;			Incorporated into CDS library
;
; Version     :	Version 1, 30 March 1995
;-
;
;			Check the input parameter.
;
IF (n_params(0) LT 1) THEN wait = 0
;
;			Get the keystroke.
;
key = byte(get_kbrd(wait))
key = key(0)
;
;			If it is an ESCAPE, get the rest of it and 
;			then decode it.
;
IF (key EQ 27B) THEN BEGIN
	st = bytarr(10)
;
;				Get the rest of the escape sequence.
;
	i = 0
	REPEAT BEGIN
		key = byte(get_kbrd(0))
		st(i) = key(0)
		i = i + 1
	ENDREP UNTIL (st(i-1) EQ 0B)
;
;				Decode the escape sequence.
;
	CASE string(st) OF
		'[A' : key = 128B
		'[B' : key = 130B
		'[D' : key = 129B
		'[C' : key = 131B
		ELSE : BEGIN
				 IF (i GT 1) THEN key = 0B ELSE key = 27B
		       END
	ENDCASE
ENDIF
;
;			If it is a CSI, get the rest of it and 
;			then decode it.
;
IF (key EQ '9B'XB) THEN BEGIN
	st = bytarr(10)
;
;				Get the rest of the sequence.
;
	i = 0
	REPEAT BEGIN
		key = byte(get_kbrd(0))
		st(i) = key(0)
		i = i + 1
	ENDREP UNTIL (st(i-1) EQ 0B)
;
;				Decode the sequence.
;
	CASE string(st) OF
		'A' : key = 128B
		'B' : key = 130B
		'D' : key = 129B
		'C' : key = 131B
		ELSE : BEGIN
				 IF (i GT 1) THEN key = 0B ELSE key = '9B'XB
		       END
	ENDCASE
ENDIF
;
;			If it is a SS3, get the rest of it and 
;			then decode it.
;
IF (key EQ '8F'XB) THEN BEGIN
	st = bytarr(10)
;
;				Get the rest of the sequence.
;
	i = 0
	REPEAT BEGIN
		key = byte(get_kbrd(0))
		st(i) = key(0)
		i = i + 1
	ENDREP UNTIL (st(i-1) EQ 0B)
;
;				Decode the sequence.
;
	CASE string(st) OF
		ELSE : BEGIN
				 IF (i GT 1) THEN key = 0B ELSE key = '8F'XB
		       END
	ENDCASE
ENDIF
;
RETURN, key
END
