;+
; Project     :	SDAC
;
; Name        :	REM_TAG
;
; Purpose     :	remove a tag from a structure
;
; Explanation :	
;
; Use         : NEW_STRUCT=REM_TAG(STRUCT,TAG)
;
; Inputs      :	STRUCT = input structure (array or scalar)
;             : TAG = array of tag names to remove
;
; Opt. Inputs :	None.
;
; Outputs     :	NEW_STRUCT = new structure
;
; Opt. Outputs:	None.
;
; Keywords    :	NAME = new name for output structure
;
; Calls       :	CONCAT_STRUCT
;
; Common      :	None.
;
; Restrictions:	None.
;
; Side effects:	None.
;
; Category    :	Structure handling
;
; Prev. Hist. :	None.
;
; Written     :	Dominic Zarro (ARC)
;
; Version     :	Version 1.0, 7 November 1994
;-


function rem_tag,struct,tag_name,name=name

on_error,1

if (datatype(struct) ne 'STC') then begin
 message,'syntax --> NEW_STRUCT=REM_TAG(STRUCT,TAG_NAME)',/cont
 if exist(struct) then return,struct else return,0
endif

if datatype(name) ne 'STR' then sname='' else sname=name
sname=strtrim(sname,2) 

new_struct=0
tags=tag_names(struct) & ntag=n_elements(tags)
if datatype(tag_name) eq 'STR' then begin
 tag=tag_name
 match,strupcase(tag),tags,suba,subb
 if suba(0) eq -1 then begin
;  message,'no matching tags found',/cont
  return,struct
 endif
 tag_index=subb
endif else begin
 ok=where( (tag_name lt ntag) and (tag_name ge 0),cnt)
 if cnt eq 0 then return,struct
 tag_index=tag_name(ok)
 tag=tags(tag_name(ok))
endelse

new_ver=float(strmid(!version.release,0,3)) ge 3.6

if n_elements(tag_index) eq n_elements(tags) then return,-1

for k=0,n_elements(struct)-1 do begin
 if new_ver then $
  temp=create_struct(struct(k),remove=tag_index,name=sname) else $
   temp=create_struct(struct(k),remove=tag_index)
 new_struct=concat_struct(new_struct,temp)
endfor

return,new_struct & end

