;+
; Project     :	SDAC
;
; Name        :	REP_STRUCT_NAME
;
; Purpose     :	Replace structure name 
;
; Explanation :	
;
; Use         : NEW_STRUCT=REP_STRUCT_NAME(STRUCT,NEW_NAME)
;
; Inputs      :	STRUCT = input structure
;             : NEW_NAME= new structure name
;
; Opt. Inputs :	None.
;
; Outputs     :	NEW_STRUCT = new structure
;
; Opt. Outputs:	None.
;
; Keywords    :	None.
;
; Common      :	None.
;
; Restrictions:	None.
;
; Side effects:	None.
;
; Category    :	Structure handling
;
; Prev. Hist. :	None.
;
; Written     :	Dominic Zarro (ARC)
;
; Version     :	Version 1.0, 7 July 1995
;-


function rep_struct_name,struct,new_name

on_error,1

err=0

if (datatype(struct) ne 'STC') then begin
 message,'syntax --> NEW_STRUCT=REP_STRUCT_NAME(STRUCT,NEW_NAME)',/cont
 if exist(struct) then return,struct else return,0
endif

if datatype(new_name) ne 'STR' then sname='' else sname=new_name
sname=strtrim(sname,2)

;if sname eq '' then return,struct

;-- check if new name is unique

status=1
if sname ne '' then status=chk_struct_name(sname,temp=temp)

if (not status) and datatype(temp) eq 'STC' and (sname ne '') then begin
 if not match_struct(struct,temp,/type) then begin
  message,'Structure type already defined: '+new_name,/cont
  return,struct
 endif
endif

return,join_struct(nothing,struct,name=sname)

end

