;+
; Project     :	SDAC
;
; Name        :	REP_TAG_NAME
;
; Purpose     :	Replace a tag name in structure
;
; Explanation :	
;
; Use         : NEW_STRUCT=REP_TAG_NAME(STRUCT,OLD_NAME,NEW_NAME)
;
; Inputs      :	STRUCT = input structure
;             : OLD_NAME = old tag name or index
;             : NEW_NAME= new tag name
;
; Opt. Inputs :	None.
;
; Outputs     :	NEW_STRUCT = new structure
;
; Opt. Outputs:	None.
;
; Keywords    :	NAME = new name for output structure
;
; Calls       :	CONCAT_STRUCT
;
; Common      :	None.
;
; Restrictions:	None.
;
; Side effects:	None.
;
; Category    :	Structure handling
;
; Prev. Hist. :	None.
;
; Written     :	Dominic Zarro (ARC)
;
; Version     :	Version 1.0, 7 November 1994
;-


function rep_tag_name,struct,old_name,new_name,name=name

on_error,1

err=0
if (datatype(struct) ne 'STC') or $
   (datatype(new_name) ne 'STR') then begin
 message,'syntax --> NEW_STRUCT=REP_TAG_NAME(STRUCT,OLD_NAME,NEW_NAME)',/cont
 if exist(struct) then return,struct else return,0
endif

if n_elements(old_name) ne 1 then begin
 message,'restricted to replacing one tag at a time',/cont
 if exist(struct) then return,struct else return,0
endif

new_struct=0
tags=tag_names(struct) & ntags=n_elements(tags)
if datatype(old_name) eq 'STR' then begin
 clook=where(tags eq strupcase(old_name),cnt)
 if cnt eq 0 then begin
  message,'tag name < '+old_name+' > not found',/cont
  return,struct
 endif
endif else begin
 clook=old_name 
 if (clook lt 0) or (clook gt (ntags-1)) then begin
  message,'index out of range',/cont
  return,struct
 endif
endelse

;-- structure name

if datatype(name) ne 'STR' then sname='' else sname=name
sname=strtrim(sname,2) 

tag_index=clook(0)
for k=0,n_elements(struct)-1 do begin
 s=struct(k)
 tag_value=s.(tag_index)
 temp=rem_tag(s,old_name)
 temp_struct=add_tag(temp,tag_value,new_name,index=tag_index-1,name=sname)
 new_struct=concat_struct(new_struct,temp_struct)
endfor
return,new_struct & end


