;+
; Project     :	SDAC
;
; Name        :	REP_TAG_VALUE
;
; Purpose     :	replace tag value in a structure
;
; Explanation :	Useful for avoiding name definition
;               conflicts when changing structure fields
;
;
; Use         : NEW_STRUCT=REP_TAG_VALUE(STRUCT,TAG_VALUE,TAG_NAME)
;
; Inputs      :	STRUCT = input structure
;             : TAG_VALUE = value to give tag
;             : TAG_NAME = string tag name to modify (or index value)
;
; Opt. Inputs :	None.
;
; Outputs     :	NEW_STRUCT = new structure
;
; Opt. Outputs:	None.
;
; Keywords    :	NAME = name to give output structure [def = ANON].
;
; Calls       : CONCAT_STRUCT
;
; Common      :	None.
;
; Restrictions:	Restricted to changing single tags at a time
;
; Side effects:	None.
;
; Category    :	Structure handling
;
; Prev. Hist. :	None.
;
; Written     :	Dominic Zarro (ARC)
;
; Version     :	Version 1.0, 4 May 1995
;-


function rep_tag_value,struct,tag_value,tag_name,name=name

on_error,1

if (datatype(struct) ne 'STC') or (n_elements(tag_value) eq 0) or $
   (n_elements(tag_name) eq 0) then begin
 message,'syntax --> NEW_STRUCT=REP_TAG_VALUE(STRUCT,TAG_VALUE,TAG_NAME)',/cont
 if exist(struct) then return,struct else return,0
endif

if n_elements(tag_name) ne 1 then begin
 message,'restricted to replacing one tag at a time',/cont
 if exist(struct) then return,struct else return,0
endif

;- simply append tag if not present

if datatype(name) ne 'STR' then sname='' else sname=name
sname=strtrim(sname,2) 

tags=tag_names(struct) & ntags=n_elements(tags)
if datatype(tag_name) eq 'STR' then begin
 tag_index=(where(strupcase(tag_name) eq tags,cnt))(0)
 if cnt eq 0 then tag_index=ntags
 str_tag_name=tag_name
endif else begin
 tag_index=tag_name 
 if (tag_index lt 0) or (tag_index gt (ntags-1)) then begin
  message,'index out of range',/cont
  return,struct
 endif
 str_tag_name=tags(tag_index)
endelse

new_struct=0

for k=0,n_elements(struct)-1 do begin
 s=struct(k)
 temp=rem_tag(s,tag_name)
 temp_struct=add_tag(temp,tag_value,str_tag_name,index=tag_index-1,name=sname)
 new_struct=concat_struct(new_struct,temp_struct)
endfor
return,new_struct & end

