;+
; Project     : SOHO - CDS     
;                   
; Name        : REPSTR()
;               
; Purpose     : Replaces all occurrences of a substring within a string.
;               
; Explanation : All occurrences of the specified string within a string 
;               are replaced by the new string.
;
;               eg.  IDL> x = 'abcdefgcd'
;                         print,repstr(x,'cd','qq')  --> 'abqqefgqq'
;
;               See STREP for replacement of first occurrence only.
;               
; Use         : IDL> new = repstr(old,out_str [,in_str])
;    
; Inputs      : old      - string in which to replace string.
;               out_str  - string to be replaced
;
; Opt. Inputs : in_str  - string to be inserted in place of out_str.
;                         (Default is a space).
;
;               
; Outputs     : Function returns suitably adapted string.
;               
; Opt. Outputs: None
;               
; Keywords    : None
;
; Calls       : None
;
; Common      : None
;               
; Restrictions: None
;               
; Side effects: None
;               
; Category    : Util, string
;               
; Prev. Hist. : Robert S. Hill, ST Systems Corp., April 1989.
;
; Written     : CDS version by C D Pike, RAL, 24-Jun-94
;               
; Modified    : 
;
; Version     : Version 1, 24-Jun-94
;-            

function repstr,obj,in,out
;
;  check parameters
;
if (n_params() lt 2) then begin
  print,' Replace all occurrences of one string with another '+$
    'in a text string.'
  print,' new = repstrr(old, c1, [c2])'
  print,'   old = original text string.         '
  print,'   c1 = string to replace.          '
  print,'   c2 = string to replace it with (default is a space). '
  print,'   new = edited string.                '
  return, ''
endif

sz2 = size(out)
ne2 = n_elements(sz2)
if (sz2(ne2-2) eq 0) then out = ''
l1 = strlen(in)
l2 = strlen(out)
last_pos = 0
lo = 9999
pos = 0
object=obj
while (pos lt lo-l1) and (pos ge 0) do begin
   lo = strlen(object)
   pos = strpos(object,in,last_pos)
   if (pos ge 0) then begin
      first_part = strmid(object,0,pos)
      last_part  = strmid(object,pos+l1,9999)
      object = first_part + out + last_part
   endif
   last_pos = pos + l2
endwhile
return,object
end
