;+
; Project     : SOHO - CDS
;
; Name        : STR2FILE
;
; Purpose     : print string array to a file
;
; Category    : utility
;
; Explanation : 
;
; Syntax      : IDL> str2file,array,file
;
;
; Inputs      : ARRAY = string array to print
;
; Opt. Inputs : FILE = filename for output
;               (if not given, defaults to str2file.tmp home directory)
;
; Outputs     : None
;
; Opt. Outputs: None
;
; Keywords    : VERBOSE - set to output info
;
; Common      : None
;
; Restrictions: ARRAY must be string
;
; Side effects: None
;
; History     : Version 1,  1-Feb-1996,  D.M. Zarro.  Written
;
; Contact     : DZARRO@SOLAR.STANFORD.EDU
;-

pro str2file,array,file,verbose=verbose

on_error,1

if datatype(array) ne 'STR' then begin
 message,'input array must be a string',/cont
 return
endif

if datatype(file) ne 'STR' then begin
 file=concat_dir(getenv('HOME'),'str2file.tmp')
 if keyword_set(verbose) then message,'array printed to '+file,/cont
endif

ok=test_open(file,/write)
if ok then begin
 openw,lun,file,/get_lun
 for i=0,n_elements(array)-1 do printf,lun,array(i)
 close,lun & free_lun,lun
endif

return & end
