function strnumber,st,val
;+
; Project     : SOHO - CDS
;
; Name        : 
;	STRNUMBER()
; Purpose     : 
;	Function to determine if a string is a valid numeric value.
; Explanation : 
;	Function to determine if a string is a valid numeric value.
;
;	This routine is mainly here to support routines from the IDL Astronomy
;	User's Library.  The routine VALID_NUM performs the same function, but
;	is more robust.
;
; Use         : 
;	result = strnumber( st, [val] )
; Inputs      : 
;	st - string
; Opt. Inputs : 
;	None.
; Outputs     : 
;	1 is returned as the function value if the string st has a
;	valid numeric value, otherwise, 0 is returned.
; Opt. Outputs: 
;	val - (optional) value of the string.  real*8
; Keywords    : 
;	None.
; Calls       : 
;	None.
; Common      : 
;	None.
; Restrictions: 
;	None.
; Side effects: 
;    (1)   Note that a blank string (e.g. " ") is not a valid numeric value, 
;          although an empty string ("") is (=0.0).
;    (2)   In V2.2.2 there was a bug in the IDL ON_IOERROR procedure that
;          will cause the following statement to hang up IDL
;
;		IDL> print,'' + string( strnumber('xxx') )
;
;          This bug was fixed in V2.3.0
;     (3)  As of V2.3.2, an IDL bug is seen in the following statements 
;
;		IDL> st = 'E'
;		IDL> q = strnumber(st)  & print,st
;
;         The variable 'st' gets modified to an empty string.   This problem
;         is related to the ambiguity of whether 'E' is a number or not 
;         (could be = 0.0E).    A fix is expected a new IDL version.
; Category    : 
;	Utilities, Numerical
; Prev. Hist. : 
;	version 1  By D. Lindler Aug. 1987
; Written     : 
;	Don Lindler, GSFC/HRS August 1987.
; Modified    : 
;	Version 1, William Thompson, GSFC, 12 April 1993.
;		Incorporated into CDS library.
; Version     : 
;	Version 1, 12 April 1993.
;-
;
 if N_params() EQ 0 then begin
      print,'Syntax - result = strnumber( st, [val] )
      return, 0
 endif

 On_IOerror,L1			;Go to L1 if conversion error occurs
 val = double(st)
 return, 1			;No conversion error
 L1: return, 0			;Conversion error occured
 end
