;+
; Project     : SOHO - CDS
;
; Name        : WHERE_VECTOR
;
; Purpose     : WHERE function for vectors
;
; Category    : Utility
;
; Explanation :
;
; Syntax      : IDL> ok=where_vector(vector,array,count)
;
; Inputs      : VECTOR = vector with with search elements
;               ARRAY = array to search for each element
;
; Opt. Inputs : None
;
; Outputs     : OK = subscripts of elements in ARRAY that match elements in vector

; Opt. Outputs: COUNT = total # of matches found
;
; Keywords    : TRIM = trim inputs if string inputs
;               CASE = make case sensitive if string inputs 
;
; Common      : None
;
; Restrictions: None
;
; Side effects: None
;
; History     : Version 1,  25-Dec-1995,  D.M. Zarro.  Written
;
; Contact     : DZARRO@SOLAR.STANFORD.EDU
;-


function where_vector,vector,array,count,trim_string=trim_string,case_sens=case_sens

count=0
if not exist(vector) or not exist(array) then return,-1

;-- protect inputs and modify

trim_string=keyword_set(trim_string)
case_sens=keyword_set(case_sens)
svec=vector & sarr=array
if datatype(vector) eq 'STR' then begin
 if trim_string then svec=strtrim(vector,2)
 if not case_sens then svec=strupcase(svec)
endif
if datatype(array) eq 'STR' then begin
 if trim_string then sarr=strtrim(array,2)
 if not case_sens then sarr=strupcase(sarr)
endif

state=''
nvecs=n_elements(svec)
pieces=strarr(nvecs)
for i=0,nvecs-1 do begin
 index=strtrim(string(i),2)
 pieces(i)='(svec('+index+') eq sarr)'
 if i eq 0 then pieces(i)='clook=where('+pieces(i)
 if i eq (nvecs-1) then pieces(i)=pieces(i)+',count)'
 if (nvecs eq 1) or (i eq 0) then conn='' else conn=' or '
 state=state+conn+pieces(i)
endfor

status=execute(strcompress(strtrim(state,2)))


return,clook & end

