;+
; Project     : SOHO - CDS
;
; Name        : X2PS
;
; Purpose     : convert X window plot to postscript file
;
; Category    : plotting
;
; Explanation : uses TVREAD
;
; Syntax      : IDL> x2ps,file,windex=windex
;
; Inputs      : FILE = filename to print
;
; Opt. Inputs : FILE - output postscript file name
;
; Outputs     : None
;
; Opt. Outputs: None
;
; Keywords    :
;               windex = index of window to be plotted (def = last window)
;               color  = for color postscript
;               x_size,y_size = size of current window to read (def = whole)
;               print  = send PS file to printer
;
; Common      : None
;
; Restrictions: None
;
; Side effects: None
;
; History     : Version 1,  1-Sep-1995,  D.M. Zarro.  Written
;
; Contact     : DZARRO@SOLAR.STANFORD.EDU
;-
 
pro x2ps,file,windex=windex,x_size=x_size,y_size=y_size,_extra=e,$
          color=color,print=print

on_error,1

if n_elements(file) eq 0 then begin
 file='idl.ps'
 message,'Postscript file saved in '+file,/cont
endif

if n_elements(color) eq 0 then color=0

if ((n_elements(windex) eq 0) and (!d.window eq -1)) or (!d.name ne 'X') then $
 message,'NO WINDOW ACTIVE'

if n_elements(windex) ne 0 then begin
 if windex gt -1 then wset,windex
endif

;-- defaults

xsize=18
ysize=18
yoff=25.5
bits=8

;-- read window

if n_elements(x_size) eq 0 then x_size=!d.x_size
if n_elements(y_size) eq 0 then y_size=!d.y_size

a=tvrd(0,0,x_size,y_size)

;-- output to Postscript

dev_sav=!d.name & set_plot,'PS',/copy
device,/land,xsize=xsize,ysize=ysize,yoff=yoff,bits=bits,_extra=e,$
       color=color,file=file

tv,a

device,/close
set_plot,dev_sav

if keyword_set(print) then xprint,file

return & end


