;+
; Project     :	SOHO/CDS
;
; Name        : XACK
;
; Purpose     : Make user acknowledge an action
;
; Use         : xack
;
; Inputs      : 
;
; Opt. Inputs : ARRAY = message to user
;
; Outputs     : None.
;
; Keywords    : 
;               GROUP = widget ID of calling widget.
;               MODAL = set to make calling widget insensitive.
;               SPACE = lines of border space surrounding message text.
;               XOFF,YOFF = pixel (X,Y) offsets relative to calling widget.
;               INSTRUCT = optional instruction to supersede "Acknowlege" 
; Explanation :
;
; Calls       : None.
;
; Common      : None.
;
; Restrictions: None.
;
; Side effects: None.
;
; Category    : Widgets
;
; Prev. Hist. : None.
;
; Written     :	Zarro (ARC/GSFC) 12 October 1994
;
; Version     : 1
;-

pro xack_event,  event                         ;event driver routine

on_error,1

widget_control, event.id, get_uvalue = uservalue

if (n_elements(uservalue) eq 0) then uservalue=''
wtype=widget_info(event.id,/type)

;-- button widgets

if (wtype eq  1) or (wtype eq 4) then begin
 bname=strtrim(uservalue,2)

 case bname of 

  'close'   : begin  xkill,event.top & end

  else:  return
 endcase
endif
return & end

;--------------------------------------------------------------------------- 

pro xack,array,group=group,xoff=xoff,yoff=yoff,modal=modal,space=space,$
         font=font,instruct=instruct,icon=icon,xsize=xsize,ysize=ysize

common xack_com,image,r,g,b
on_error,1

if not have_widgets() then message,'widgets unavailable'

if xregistered('xack') then begin
 xmanager & return
endif

;-- make widgets

bfont="-adobe-courier-bold-r-normal--25-180-100-100-m-150-iso8859-1"
if datatype(font) eq 'STR' then bfont=font
bfont=(get_dfont(bfont))(0)

tfont = (get_dfont('-misc-fixed-bold-r-normal--15-100-100-100-c-70-iso8859-1'))(0)
tfont='9x15bold'
tfont=(get_dfont(tfont))(0)

get_screen,fspace,fxpad,fypad
wbase=widget_base(title=' ',/column,space=fspace,xpad=fxpad,ypad=fypad)

;-- read icon file

if n_elements(found) eq 0 then found=0
if n_elements(searched) eq 0 then searched=0
icon=keyword_set(icon)
if icon then begin
 if not searched then begin
  look=loc_file('stop.gif',path=get_lib(),count=nf)
  if nf gt 0 then found=1
  if found then read_gif,look(0),image,r,g,b
  searched=1
 endif
endif

if icon and found then begin
 tvlct,rs,gs,bs,/get
 if n_elements(xsize) eq 0 then  xsize=64
 if n_elements(ysize) eq 0 then  ysize=64
 sz=size(image)
 simage=congrid(image,xsize,ysize)
 sz=size(simage)
 row=widget_base(wbase,/row,space=fspace,xpad=20.*fxpad,ypad=fypad)
 draw=widget_draw(row,xsize=sz(1),ysize=sz(2),uvalue='icon',$
                   retain=2,/button_event,/frame)
endif

if datatype(instruct) eq 'STR' then mess=instruct else mess='Acknowledge'

if datatype(array) eq 'STR' then begin
 row1=widget_base(wbase,/column,space=fspace,xpad=fxpad,ypad=fypad)
 if n_elements(space) eq 0 then begin
  sy=(n_elements(array) < 5)
  blank=replicate('',(sy/2 > 3))
 endif else begin
  if space gt 0 then blank=replicate('',space)
 endelse
 if n_elements(blank) gt 0 then sarr=[blank,array,blank] else sarr=array
 ysize=n_elements(sarr)
 wtext=widget_text(row1,xsize=max(strlen(array)) > strlen(mess),$
                   ysize=ysize,value=sarr,font=tfont)
endif
 
row2=widget_base(wbase,/column,space=fspace,xpad=fxpad,ypad=fypad)


c1=widget_base(row2,/row,space=fspace,xpad=fxpad,ypad=fypad)


ackb=widget_button(c1,uvalue='close',/no_release,font=bfont,$
                   /frame,value=mess)

if (n_elements(xoff) eq 0) and (n_elements(yoff) eq 0) then begin
 offsets=get_cent_off(wbase,group,valid=valid)
 if valid then begin
  xoff=offsets(0) & yoff=offsets(1)
 endif
endif
if (n_elements(xoff) eq 0) and (n_elements(yoff) eq 0) then $
 widget_control,wbase,/realize,/map else $
  widget_control,wbase,/realize,tlb_set_xoff=xoff,tlb_set_yoff=yoff,/map

if icon and found then begin
 widget_control,draw,get_value=win_index
 tvlct,r,g,b
 wset,win_index
 tv,simage
endif

;-- Make a beep if ICON is used

if icon then bell

xmanager,'xack',wbase,group=group,just_reg=just_reg,/modal

if icon and found then tvlct,rs,gs,bs

if keyword_set(group) then xshow,group
 

return & end

