;---------------------------------------------------------------------------
; Document name: xanswer.pro
; Created by:    Liyun Wang, GSFC/ARC, March 8, 1995
;
; Last Modified: Thu Feb 15 15:01:30 1996 (lwang@achilles.nascom.nasa.gov)
;---------------------------------------------------------------------------
;
;+
; PROJECT:
;       SOHO - CDS/SUMER
;
; NAME:
;       XANSWER()
;
; PURPOSE:
;       Popup widget to get a Yes/No answer for a given question
;
; EXPLANATION:
;
; CALLING SEQUENCE:
;       Result = xanswer(question [,/str])
;
; INPUTS:
;       QUESTION - A string scalar or vector for the question presented to the
;                  user
;
; OPTIONAL INPUTS:
;       FLASH - Make the question flash for number of FLASH times
;       RATE  - Flashing rate in seconds; default: 0.25 sec.
;
; OUTPUTS:
;       RESULT - A numerical value of 1 or 0, or a string scalar with a value
;                'Y' or 'N' if the keyword STR is set
;
; OPTIONAL OUTPUTS:
;       None.
;
; KEYWORD PARAMETERS:
;       STR        - Set this keyword to make string type return
;       BEEP       - Make a beep if set
;       CENTER     - Centerize the question
;       RIGHT      - Right justify the question
;       SPACE      - Number of line to space text; default to 3
;       JUST_REG   - Just register with xmanager
;       XOFF, YOFF - Pixel offset relative to caller
;       FONT       - Font for text widget
;
; CALLS:
;       DATATYPE, BELL, JUSTIFY
;
; COMMON BLOCKS:
;       None.
;
; RESTRICTIONS:
;       None.
;
; SIDE EFFECTS:
;       All events are trapped and all other widgets are desensitized until an
;       option is chosen. (The keyword MODAL is used with xmanager)
;
; CATEGORY:
;       Utility, widget
;
; X RESOURCES:
;       Idl*YesButton, Idl*NoButton
; 
; PREVIOUS HISTORY:
;       Written March 8, 1995, Liyun Wang, GSFC/ARC
;
; MODIFICATION HISTORY:
;       Version 1, created, Liyun Wang, GSFC/ARC, March 8, 1995
;       Version 2, Liyun Wang, GSFC/ARC, May 2, 1995
;          Added INSTRUCT keyword
;       Version 3, Liyun Wang, GSFC/ARC, May 2, 1995
;          Got rid of common block
;       Version 4, November 15, 1995, Liyun Wang, GSFC/ARC
;          Changed exclusive button to regular button
;          Added Xresource option
;       Version 5, February 15, 1996, Liyun Wang, GSFC/ARC
;          Xresource option disabled for IDL version 3.5 and earlier
;
; VERSION:
;       Version 5, February 15, 1996
;-
;
PRO xanswer_event, event
   WIDGET_CONTROL, event.top, get_uvalue = unseen
   WIDGET_CONTROL, event.id, get_uvalue = opt
   CASE (opt) OF
      'yes': BEGIN
         answer = 1
         WIDGET_CONTROL, unseen, set_uvalue = answer
         WIDGET_CONTROL, event.top, /destroy
      END
      'no': BEGIN
         answer = 0
         WIDGET_CONTROL, unseen, set_uvalue = answer
         WIDGET_CONTROL, event.top, /destroy
      END
      ELSE:
   ENDCASE
END

FUNCTION xanswer, question, str=str, flash=flash, beep=beep, rate=rate, $
                  center=center, right=right, space=space, font=font, $
                  title=title, group=group, xoff=xoff, yoff=yoff,$
                  instruct=instruct

   ON_ERROR, 2
   IF datatype(question) NE 'STR' THEN BEGIN
      question = 'Do you wish to continue?'
   ENDIF
   IF N_ELEMENTS(rate) EQ 0 THEN rate = 0.25
   IF N_ELEMENTS(space) EQ 0 THEN space = 3
   IF N_ELEMENTS(title) EQ 0 THEN title = 'XANSWER'
   IF space GT 0 THEN buff = REPLICATE('',space)

   wfont="-adobe-courier-bold-r-normal--25-180-100-100-m-150-iso8859-1"
   wfont=(get_dfont(wfont))(0)

   IF N_ELEMENTS(font) EQ 0 THEN BEGIN
      ffont= get_dfont('-*-courier-*-r-normal-*-18-*-*-*-*-*-*-*')
      IF ffont(0) EQ '' THEN font = '9x15bold' ELSE font = ffont(0)
   ENDIF

   base = WIDGET_BASE(title = title, /column, /frame)
   base1 = WIDGET_BASE(base, /column, /frame)

   IF space GT 0 THEN text = [buff,question,buff] ELSE text = question
   xsize = (MAX(STRLEN(text)) < 80)
   ysize = (N_ELEMENTS(text) < 50)

   IF KEYWORD_SET(center) THEN text = justify(text, just='|')
   IF KEYWORD_SET(right) THEN text = justify(text, just='>')

   wtext = WIDGET_TEXT(base1, value = text, /frame, font = font, $
                       xsize = xsize, ysize = ysize)

   IF N_ELEMENTS(instruct) EQ 0 THEN BEGIN
      tmp = WIDGET_BASE(base1, /row, /frame, xpad=30, space=15)
      IF !version.release LT '3.6' THEN BEGIN
         tmp1 = WIDGET_BUTTON(tmp, value='Yes', uvalue='yes', font=wfont, $
                              /no_release)
         tmp1 = WIDGET_BUTTON(tmp, value='No', uvalue='no', font=wfont, $
                              /no_release)
      ENDIF ELSE BEGIN
         tmp1 = WIDGET_BUTTON(tmp, value='Yes', uvalue='yes', font=wfont, $
                              resource='YesButton', /no_release)
         tmp1 = WIDGET_BUTTON(tmp, value='No', uvalue='no', font=wfont, $
                              resource='NoButton', /no_release)
      ENDELSE
;      xmenu, ['Yes','No'], base1, /frame, /exclusive, /no_release, /row, $
;         uvalue = ['yes','no'], font = wfont
   ENDIF ELSE BEGIN
      temp = WIDGET_BASE(base1, /row, /frame)
      inst = WIDGET_LABEL(temp, value = instruct, font = wfont)
      tmp = WIDGET_BASE(temp, /row, space=10)
      IF !version.release LT '3.6' THEN BEGIN
         tmp1 = WIDGET_BUTTON(tmp, value='Yes', uvalue='yes', font=wfont)
         tmp1 = WIDGET_BUTTON(tmp, value='No', uvalue='no', font=wfont)
      ENDIF ELSE BEGIN 
         tmp1 = WIDGET_BUTTON(tmp, value='Yes', uvalue='yes', font=wfont, $
                              resource='YesButton')
         tmp1 = WIDGET_BUTTON(tmp, value='No', uvalue='no', font=wfont, $
                              resource='NoButton')
      ENDELSE
;      xmenu, ['Yes','No'], temp, /exclusive, /no_release, /row, $
;         uvalue = ['yes','no'], font = wfont
   ENDELSE

   offsets = get_cent_off(base, valid = valid)
   IF valid THEN $
      WIDGET_CONTROL, base, /realize, /map, tlb_set_xoff=offsets(0),$
      tlb_set_yoff=offsets(1), /show $
   ELSE $
      WIDGET_CONTROL, base, /realize, /map, /show

   IF KEYWORD_SET(beep) THEN bell
   IF N_ELEMENTS(flash) NE 0 AND datatype(flash) EQ 'INT' THEN BEGIN
      FOR i = 0, flash-1 DO BEGIN
         WIDGET_CONTROL, wtext, set_value = ''
         WAIT, rate
         WIDGET_CONTROL, wtext, set_value = text
         WAIT, rate
      ENDFOR
   ENDIF

   unseen = WIDGET_BASE()
   WIDGET_CONTROL, base, set_uvalue = unseen
   XMANAGER, 'xanswer', base, /modal
   WIDGET_CONTROL, unseen, get_uvalue = answer
   IF KEYWORD_SET(str) THEN BEGIN
      IF answer THEN RETURN, 'Y' ELSE RETURN, 'N'
   ENDIF ELSE BEGIN
      IF answer THEN RETURN, 1 ELSE RETURN, 0
   ENDELSE
   WIDGET_CONTROL, unseen, /destroy
END

;---------------------------------------------------------------------------
; End of 'xanswer.pro'.
;---------------------------------------------------------------------------
