;+
; Project     :	SOHO - CDS
;
; Name        : XINPUT
;
; Purpose     : Allow user to input text
;
; Use         : xinput,text
;
; Inputs      : None.
;
; Opt. Inputs : INSTRUCT = instructions for user
;
; Outputs     : TEXT = string response text entered by user
;
; Opt. Outputs: None.
;
; Keywords    : 
;              GROUP = group leader of caller
;              MODAL = modal (make caller insensitive)
;              XOFF,YOFF = device (x,y) offsets of XINPUT base relative to caller
;              TFONT = text widget font 
;              BFONT = button widget font
;              YSIZE = ysize of input text widget
;              STATUS = 0/1 if CANCELLED/ACCEPTED
; Explanation :
;
; Calls       : None.
;
; Common      : None.
;
; Restrictions: None.
;
; Side effects: None.
;
; Category    : Widgets
;
; Prev. Hist. : None.
;
; Written     :	Zarro (ARC/GSFC) 23 October 1994
;
; Modified:   : Liyun Wang, GSFC/ARC, March 24, 1995, added MAX_LEN keyword
;               Liyun Wang, GSFC/ARC, March 29, 1995, Made the widget's
;                  width be at least MAX_LEN if MAX_LEN is passed
;
; Version     : Version 4, 30-Apr-95
;
;-


pro xinput_event,  event                         ;event driver routine

on_error,1

widget_control, event.top, get_uvalue = unseen
info=get_pointer(unseen,/no_copy)
widget_control, event.id, get_uvalue = uservalue

if (n_elements(uservalue) eq 0) then uservalue=''
wtype=widget_info(event.id,/type)

;-- button widgets

if wtype eq  1 then begin
 bname=strtrim(uservalue,2)
 if bname eq 'CANCEL' then info.status=0
 xkill,event.top
endif

;-- text widgets

if wtype eq 3 then begin
 widget_control,event.id,get_value=text
 info=rep_tag_value(info,text,'text')
endif

set_pointer,unseen,info,/no_copy
return & end

;--------------------------------------------------------------------------- 

pro xinput,text,instruct,group=group,tfont=tfont,bfont=bfont,$
 xoff=xoff,yoff=yoff,modal=modal,max_len=max_len,ysize=ysize,status=status

on_error,1

if not have_widgets() then message,'widgets unavailable'
if not xalive(group) then xkill,/all

;-- fonts

if datatype(bfont) ne 'STR' then bfont="-adobe-courier-bold-r-normal--25-180-100-100-m-150-iso8859-1"
bfont=(get_dfont(bfont))(0)
if datatype(tfont) ne 'STR' then tfont=''
tfont=(get_dfont(tfont))(0)

;-- make widgets

get_screen,fspace,fxpad,fypad

wbase=widget_base(title='XINPUT',/column,space=fspace,xpad=fxpad,ypad=fypad)

;-- input text is default value

if n_elements(ysize) eq 0 then ysize=1
if datatype(text) eq 'STR' then def_value=text else def_value=''
def_value=strtrim(def_value,2) 
text=def_value
if n_elements(max_len) eq 0 then max_len=0
sz=size(def_value)
if sz(0) eq 1 then ysize=(sz(1) < 10)
xsize=max(strlen(text)) 
if max_len gt 0 then xsize=xsize > max_len


;-- instruction box

if datatype(instruct) eq 'STR' then begin
 comment=instruct
 comment=[' ',comment,' ']
 csize=n_elements(comment)
 row1=widget_base(wbase,/column,space=fspace,xpad=fxpad,ypad=fypad)
 wtext=widget_text(row1,xsize=max(strlen(instruct)) > xsize,ysize=csize,value=comment,font=tfont,scroll=csize gt 45)
endif

row2=widget_base(wbase,/column,space=fspace,xpad=fxpad,ypad=fypad)
wtext=widget_text(row2,xsize=xsize,ysize=ysize,/editable,/all,font=tfont,value=def_value)
row3=widget_base(wbase,/row,space=20*fspace,xpad=fxpad,ypad=fypad)
temp1=widget_base(row3,/row,space=50*fspace,xpad=fxpad,ypad=fypad)
quit=widget_button(temp1,value='CANCEL',uvalue='CANCEL',font=bfont)
temp2=widget_base(row3,/row,space=50*fspace,xpad=fxpad,ypad=fypad)
ok=widget_button(temp2,value='ACCEPT',uvalue='ACCEPT',font=bfont)

;-- realize and position

if (n_elements(xoff) eq 0) and (n_elements(yoff) eq 0) then begin
 offsets=get_cent_off(wbase,group,valid=valid)
 if valid then begin
  xoff=offsets(0) & yoff=offsets(1)
 endif
endif

realized=widget_info(wbase,/realized)
if (n_elements(xoff) eq 0) and (n_elements(yoff) eq 0) then $
 widget_control,wbase,realize=(not realized),/map else $
  widget_control,wbase,realize=(not realized),tlb_set_xoff=xoff,tlb_set_yoff=yoff,/map

;-- set text insertion point

if n_elements(def_value) eq 1 then text_sel= strlen(def_value)+1  else $
 text_sel=1
;widget_control,wtext,/input_focus,set_text_select=text_sel < xsize

;-- invisible base in which to hold variables common to event handler

make_pointer,unseen
info={text:def_value,status:1}
set_pointer,unseen,info,/no_copy
widget_control, wbase, set_uvalue = unseen

xmanager,'xinput',wbase,group=group,modal=keyword_set(modal) or xalive(group)
if not xalive(group) then xmanager

;-- retrieve user text

info=get_pointer(unseen,/no_copy)
free_pointer,unseen

;-- shorten string

status=info.status 
if not status then text=def_value else begin
 text=info.text 
 if (max_len gt 0) then begin
  for i=0,n_elements(text)-1 do begin
   if max(strlen(text(i))) gt max_len then text(i)=strmid(text(i),0,max_len)
  endfor
 endif
endelse

if n_elements(text) eq 1 then text=text(0)
xshow,group

return & end



