;+
; Project     :	SOHO/CDS
;
; Name        : XLIST
;
; Purpose     : lists structure tags in a list widget.
;
; Use         : XLIST,STRUCT.
;
; Inputs      : STRUCT
;
; Opt. Inputs : None.
;
; Outputs     : INDEX = selected index of structure array
;
; Keywords    : 
;               wbase  = widget id of parent widget (input/output)
;               wlist  = widget id of list widget into which to write (input/output)
;               lfont   = list widget font (def = 'fixed')
;               bfont   = button widget font (def = 'fixed')
;               title  = title of parent base
;               tags   = tags to list
;               select = set to permit list selection
;               remove = set to permit list deletion
; Explanation :
;
; Common      : None.
;
; Restrictions: None.
;
; Side effects: None.
;
; Category    : Widgets
;
; Prev. Hist. : None.
;
; Written     :	Zarro (ARC/GSFC) 12 October 1994
;
; Version     : 1
;-

pro xlist_event,  event                         ;event driver routine

on_error,1

widget_control, event.id, get_uvalue = uservalue
widget_control,event.top,get_uvalue=unseen
info=get_pointer(unseen,/no_copy)
selected=info.selected
struct=info.struct
fields=info.fields
nfields=info.nfields

if (n_elements(uservalue) eq 0) then uservalue=''
wtype=widget_info(event.id,/type)

;-- button widget

bname=strtrim(uservalue,2)
if bname eq 'exit' then begin
 info.selected=-1
 xkill,event.top
endif

if bname eq 'select' then xkill,event.top

;-- remove elements

if bname eq 'remove' then begin
 if (selected gt -1) and (nfields gt 0) then begin
  keep=where(selected ne indgen(nfields),cnt)
  if cnt gt 0 then begin
   fields=fields(keep) & nfields=cnt
   struct=struct(keep)
  endif else begin
   fields='' & nfields=0
  endelse
  selected=-1
  info=rep_tag_value(info,struct,'struct')
  info=rep_tag_value(info,fields,'fields')
  info.nfields=nfields
  info.selected=selected
  widget_control,info.wlist,set_value=fields
  widget_control,info.wlist,sensitive=(nfields gt 0)
  if xalive(info.selb) then widget_control,info.selb,sensitive=0
  if xalive(info.remb) then widget_control,info.remb,sensitive=0
 endif
endif

;-- list widget

if wtype eq 6 then begin
 info.selected=event.index 
 if xalive(info.selb) then widget_control,info.selb,sensitive=1
 if xalive(info.remb) then widget_control,info.remb,sensitive=1
endif

set_pointer,unseen,info,/no_copy

return & end

;--------------------------------------------------------------------------- 

pro xlist,struct,index,wlist=wlist,lfont=lfont,select=select,modal=modal,$
          wbase=wbase,title=title,group=group,just_reg=just_reg,bfont=bfont,$
          xoff=xoff,yoff=yoff,wlabel=wlabel,tags=tags,center=center,$
          remove=remove,font=font

on_error,1

selected=-1
if not have_widgets() then message,'widgets unavailable'
if  (datatype(struct) ne 'STC') then message,'input must be a structure'

IF N_ELEMENTS(wlist) EQ 0 THEN wlist=0l
IF N_ELEMENTS(title) EQ 0 THEN title = 'XLIST'
wlist=long(wlist)
update=xalive(wbase)
just_reg=keyword_set(just_reg)
if not keyword_set(group) and not keyword_set(just_reg) then xkill,/all

;-- get tag definitions

stc_name=tag_names(struct,/structure_name)
if stc_name eq '' then stc_name='ANONYMOUS'
nstruct=n_elements(struct)

get_screen,fspace,fxpad,fypad

;-- fonts

if datatype(bfont) ne 'STR' then $
 cfont="-adobe-courier-bold-r-normal--25-180-100-100-m-150-iso8859-1" else $
  cfont=bfont
cfont=(get_dfont(cfont))(0)

if datatype(font) eq 'STR' then lfont=font
if datatype(lfont) ne 'STR' then font="9x15bold" else font=lfont
font=(get_dfont(font))(0)
if font eq '' then font='fixed'


;-- make widgets

if (not update) then begin
 wbase=widget_base(title=title,/column)

;-- buttons

 selb=1 & remb=1
 if (not just_reg) then begin
  row1=widget_base(wbase,/row)
  exitb=widget_button(row1,value='Exit',uvalue='exit',/no_release,/frame,font=cfont)

  if keyword_set(select) then $
   selb=widget_button(row1,value='Select and Exit',uvalue='select',/no_release,$
                    /frame,font=cfont)

  if keyword_set(remove) then $
   remb=widget_button(row1,value='Remove',uvalue='remove',/no_release,$
                    /frame,font=cfont)
 endif

;-- labels

 row=widget_base(wbase,/frame,/column)
 wlabel=widget_label(row,font=font)

;-- lists

 wlist=widget_list(wbase,/frame,ysize=20,font=font)

endif

;-- make string array for list widget

cur_tags=tag_names(struct)
ntags=n_elements(tags)
if ntags eq 0 then begin
 do_tags=cur_tags
 ntags=n_elements(cur_tags)
endif else begin
 if datatype(tags) eq 'STR' then do_tags=tags else do_tags=cur_tags(tags)
endelse
  
slabel=do_tags(0)
for k=1,ntags-1 do slabel=slabel+'   '+do_tags(k)
for j=0,nstruct-1 do begin
 tstruct=struct(j)
 tlabel=slabel
 for i=0,n_elements(cur_tags)-1 do begin
  ctag=cur_tags(i)
  clook=where(strupcase(ctag) eq strupcase(do_tags),count)
  if count gt 0 then begin
   temp=tstruct.(i)
   if datatype(temp) eq 'STC' then outsub='STRUCTURE' else $
    outsub=arr2str(temp,delim=' ')
   insub=ctag
   tlabel=strep(tlabel,insub,outsub)
  endif
 endfor
 if j eq 0 then fields=tlabel else fields=[fields,tlabel]
endfor

;-- write to list widget

widget_control,wlabel,set_value=slabel
widget_control,wlist,set_value=fields
selected=0
if keyword_set(select) then begin
 widget_control,wlist,set_list_select=selected
endif

if not update then begin
 if n_elements(xoff)*n_elements(yoff) eq 0 then begin
  offsets=get_cent_off(wbase,group,valid=valid,center=center)
  if valid then begin
   xoff=offsets(0) & yoff=offsets(1)
  endif
 endif
 realized=widget_info(wbase,/realized)
 if n_elements(xoff)*n_elements(yoff) eq 0 then $
  widget_control,wbase,realize=(not realized),/map else $
   widget_control,wbase,realize=(not realized),tlb_set_xoff=xoff,tlb_set_yoff=yoff,/map

;-- use pointer to communicate with event handler

 make_pointer,unseen
 nfields=n_elements(fields)
 info={struct:struct,fields:fields,selected:selected,selb:selb,remb:remb,wlist:wlist,nfields:nfields}
 set_pointer,unseen,info,/no_copy
 widget_control,wbase,set_uvalue=unseen

 modal=keyword_set(modal) or (xalive(group) and (not just_reg))
 xmanager,'xlist',wbase,group=group,just_reg=just_reg,modal=modal
 if (not xalive(group)) and (not just_reg) then xmanager

endif else xshow,wbase

if (not just_reg) and (keyword_set(select) or keyword_set(remove)) then begin
 info=get_pointer(unseen,/no_copy)
 index=info.selected
 struct=info.struct
 if info.nfields eq 0 then delvarx,struct
 free_pointer,unseen
endif else index=-1

xshow,group

return & end

