;+
; Project     : SOHO - CDS
;
; Name        : XPRINT
;
; Purpose     : print an array or file
;
; Category    : OS, Widgets
;
; Explanation : retrieves a printer queue name from a selection
;               obtained from PRINTCAPS file
;
; Syntax      : IDL> xprint,file
;
; Inputs      : FILE = filename to print
;
; Opt. Inputs : None
;
; Outputs     : None
;
; Opt. Outputs: None
;
; Keywords    : STATUS = 0/1 if selection aborted/continued
;               ARRAY = alternative string array to print
;
; Common      : None
;
; Restrictions: currently works best for UNIX
;
; Side effects: None
;
; History     : Version 1,  1-Sep-1995,  D.M. Zarro.  Written
;
; Contact     : DZARRO@SOLAR.STANFORD.EDU
;-

pro xprint,file,array=array,group=group,status=status,$
          qual=qual,delete=delete,instruct=instruct

on_error,1

;-- select printer

if datatype(instruct) ne 'STR' then pstruct='' else pstruct=instruct
sel_printer,printer,status=status,group=group,instruct=pstruct

if status then begin
 widget_control,/hour
 send_printer,file,que=printer,array=array,qual=qual,delete=delete,err=err
 if err eq '' then xtext,'   Print successful   ',/just_reg,wait=1 else $
  xack,err,group=group
endif
 
return & end

