;+
; PROJECT:
;       SOHO - CDS/SUMER
;
; NAME:
;       XPS_SETUP
;
; PURPOSE:
;       Widget interface to PS
;
; CATEGORY:
;       Utitlity, widget
;
; EXPLANATION:
;
; SYNTAX:
;       xps_setup,ps_setup
;
; INPUTS:
;       None required.
;
; OPTIONAL INPUTS:
;       PS_SETUP - PS parameter structure for setting up the PS device. If it
;                is not defined when the routine is called, it will 
;                be defined by the routine. It may be modified upon exiting
;                from the program. It should have the following tags:
;
;                FILENAME     - Name of PS file. Default: idl.ps
;                PORTRAIT     - 1 for portrait, 0 for landscape
;                COLOR        - 0/1 indicating if color plot is needed
;                ENCAPSULATED - 0/1 indicating if EPS file is needed
;                COPY         - 0/1 indicating whether to copy the current
;                               color table to the PostScript device
;                INTERPOLATE  - 0/1 indicating whether to interpolate the
;                               current color table to the PostScript device
;
;                Note: COPY and INTERPOLATE are only meaningful when
;                      COLOR is set. Both cannot be set.
;
; OUTPUTS:
;       PS_SETUP - PS parameter structure
; OPTIONAL OUTPUTS:
;       None.
;
; KEYWORDS:
;       INITIAL - Create the PS_SETUP structure without popping up the
;                 widget if set
;       GROUP   - ID of the widget who serves as a group leader
;       FONT    - optional font for labels
;       STATUS - 0/1 for Cancel/Accept option
; COMMON:
;       XPS_SETUP: contains most recent setup structure
;
; RESTRICTIONS:
;       None.
;
; SIDE EFFECTS:
;       None.
;
; HISTORY:
;       Version 1, October 6, 1995, Liyun Wang, GSFC/ARC. Written
;
; CONTACT:
;       Liyun Wang, GSFC/ARC (Liyun.Wang.1@gsfc.nasa.gov)
;-
;
;---------------------------------------------------------------------------
;  Event handler
;---------------------------------------------------------------------------
PRO xps_setup_event, event
   ON_ERROR, 1

   WIDGET_CONTROL, event.top, get_uvalue = unseen
   info=get_pointer(unseen,/no_copy)
   WIDGET_CONTROL, event.id, get_uvalue = uvalue

   quit_flag=0
   CASE (uvalue) OF
      'DONE': BEGIN
         info.status = 1
         WIDGET_CONTROL, info.fname, get_value=str
            if strtrim(str(0),2) eq '' then pfile='idl.ps' else pfile=str(0)
            info.ps_stc.filename = pfile
         if info.ps_stc.hard then info.ps_stc.encapsulated = 0
         quit_flag=1
      END

      'QUIT': BEGIN
         info.status = 0
         quit_flag=1
      END

      'TO_FILE': BEGIN
         info.ps_stc.hard = 0
         WIDGET_CONTROL, info.ebt(0), sensitive=1
         WIDGET_CONTROL, info.dbase,sensitive=0
         WIDGET_CONTROL, info.hbase,sensitive=0
      END
      'PRINTER': BEGIN
         info.ps_stc.hard = 1
         WIDGET_CONTROL, info.ebt(0), sensitive=0
         WIDGET_CONTROL, info.dbase,sensitive=1
         WIDGET_CONTROL, info.hbase,sensitive=1
      END
      'PFILE': begin
        title='Select Output Postscript Filename'
        tfile=info.ps_stc.filename
        break_file,tfile,dsk,direc,name
        path=dsk+direc
        cd,curr=curr_dir
        if strtrim(path,2) eq '' then path=curr_dir
        if tfile eq '' then tfile='idl.ps'
        fname=pickfile(filter='*.ps',file=tfile,path=path,title=title,$
                       group=event.top)
        xshow,event.top
        if fname ne '' then begin
         info.ps_stc.filename=fname
         widget_control,info.fname,set_value=fname
        endif
       end
      'FNAME': BEGIN
         WIDGET_CONTROL, info.fname, get_value=str
         info.ps_stc.filename = str(0)
      END
      'PSELECT': BEGIN
         IF os_family() ne 'vms' THEN BEGIN
          sel_printer,que,status=status,group=event.top,def=info.ps_stc.printer
          IF status THEN BEGIN
             info.ps_stc.printer = que
             WIDGET_CONTROL, info.pname, set_value=que
          ENDIF
         ENDIF
      END
      'DFILE': info.ps_stc.delete=event.select
      'PORT': info.ps_stc.portrait = event.select
      'LAND': info.ps_stc.portrait = 1-event.select
      'COLOR': BEGIN
         info.ps_stc.color = event.select
         WIDGET_CONTROL, info.cbase, sensitive=event.select
      END
      'ENCAP': info.ps_stc.encapsulated = event.select
      'COPY': begin
        info.ps_stc.copy = event.select
        if event.select then begin
         info.ps_stc.interpolate =0
         widget_control,info.pbt(1),set_button=0
        endif
       end
      'INTER': begin
        info.ps_stc.interpolate = event.select
        if event.select then begin
         info.ps_stc.copy =0
         widget_control,info.pbt(0),set_button=0
        endif
       END
      ELSE:
   ENDCASE

   if quit_flag then xkill,event.top

   set_pointer,unseen,info,/no_copy

   return
END

;---------------------------------------------------------------------------
;  Main Program
;---------------------------------------------------------------------------
PRO xps_setup, ps_setup, group=group, initial=initial,font=font,status=status

   common xps_setup,ps_setup_com

   ON_ERROR, 1

;-- initialize

   status=0
   if os_family() eq 'vms' then def_prn='SYS$PRINT' else def_prn='lp0'
   ps_setup_def= {filename:'idl.ps', portrait:0, color:0, encapsulated:0,$
                copy:0, interpolate:0, hard:1, printer:def_prn,delete:0}

   if keyword_set(initial) then begin
     ps_setup=ps_setup_def & return
   endif

   if datatype(ps_setup_com) ne 'STC' then ps_setup_com=ps_setup_def
   get_from_com=0
   if (datatype(ps_setup) eq 'STC') then begin
    if not match_struct(ps_setup,ps_setup_def,/tag) then get_from_com=1
   endif else get_from_com=1
   if get_from_com then ps_stc=ps_setup_com else ps_stc=ps_setup

   if not xalive(group) then xkill,/all

   bfont = '-adobe-courier-bold-r-normal--20-140-100-100-m-110-iso8859-1'
   bfont = (get_dfont(bfont))(0)

   if not exist(font) then font=bfont
   font = (get_dfont(font))(0)

   base = WIDGET_BASE(title='XPS_SETUP', /column)

   temp = WIDGET_BASE(base, /row, /frame)
   tmp = WIDGET_BUTTON(temp, value='Accept', font=bfont, uvalue='DONE')
   tmp = WIDGET_BUTTON(temp, value='Cancel', font=bfont, uvalue='QUIT')

;-- print options

   temp = WIDGET_BASE(base, /row, /frame)
   xmenu, ['Save to file', 'Send to printer'], temp, /exclusive, $
      button=hbt, font=font, uvalue=['TO_FILE','PRINTER'], /no_release
   IF ps_stc.hard THEN $
      WIDGET_CONTROL, hbt(1), /set_button $
   ELSE $
      WIDGET_CONTROL, hbt(0), /set_button

   temp = WIDGET_BASE(base,/column,/frame)

   fbase = WIDGET_BASE(temp, /row)
   tmp1 = WIDGET_BUTTON(fbase, value='Filename:', font=font,uvalue='PFILE')
   fname = WIDGET_TEXT(fbase, value=ps_stc.filename, xsize=30, font=font,$
                      /edit, uvalue='FNAME')

   hbase = WIDGET_BASE(temp, /row)
   tmp1 = WIDGET_BUTTON(hbase, value='Printer: ', font=font, uvalue='PSELECT')
   pname = WIDGET_TEXT(hbase, value=ps_stc.printer, xsize=30, font=font)
   widget_control,hbase,sensitive=ps_stc.hard

   dbase= widget_base(temp,/row)
   xmenu,['Delete file after print'],dbase,/row,/nonexclusive,font=font,$
      uvalue='DFILE',buttons=dbt,/no_release
   WIDGET_CONTROL, dbase, sensitive=ps_stc.hard
   widget_control,dbt(0),set_button=ps_stc.delete

   temp = WIDGET_BASE(base, /row, /frame)
   tmp1 = WIDGET_LABEL(temp, value='Orientation:', font=font)
   xmenu, ['Portrait', 'Landscape'], temp, /exclusive, button=obt, $
      font=font, uvalue=['PORT','LAND'], /no_release
   IF ps_stc.portrait THEN $
      WIDGET_CONTROL, obt(0), /set_button $
   ELSE $
      WIDGET_CONTROL, obt(1), /set_button

   temp = WIDGET_BASE(base, /row, /frame)
   xmenu, 'Color', temp, /nonexclusive, font=font, button=cbt, uvalue='COLOR'
   WIDGET_CONTROL, cbt(0), set_button=ps_stc.color

   xmenu, 'Encapsulated', temp, /nonexclusive, font=font, button=ebt, $
      uvalue='ENCAP'
   WIDGET_CONTROL, ebt(0), set_button=ps_stc.encapsulated
   WIDGET_CONTROL, ebt(0), sensitive=1-ps_stc.hard

;-- color options

   cbase = WIDGET_BASE(base, /row)
   xmenu, ['Copy','Interpolated'], cbase, /nonexclusive, font=font, button=pbt,$
    uvalue=['COPY','INTER'],/row,title='Color Table:'
   WIDGET_CONTROL, pbt(0), set_button=ps_stc.copy
   WIDGET_CONTROL, pbt(1), set_button=ps_stc.interpolate

   WIDGET_CONTROL, cbase, sensitive=ps_stc.color


;-- center base

   offsets=get_cent_off(base,group,valid=valid)
   if valid then begin
    xoff=offsets(0) & yoff=offsets(1)
    widget_control,base,/realize,tlb_set_xoff=xoff,tlb_set_yoff=yoff
   endif else widget_control,base,/realize

   info = {ps_stc:ps_stc, hbase:hbase, cbase:cbase, pname:pname, $
           fname:fname, status:0, ebt:ebt ,dbase:dbase,pbt:pbt}

   make_pointer,unseen
   set_pointer,unseen,info,/no_copy

   WIDGET_CONTROL, base, set_uvalue = unseen
   XMANAGER, 'xps_setup', base, group_leader = group, modal = xalive(group)
   if not xalive(group) then xmanager
   
   info=get_pointer(unseen,/no_copy)
   free_pointer,unseen
   xshow,group

   status= info.status
   if status then begin
    ps_setup_com=info.ps_stc
    if (not get_from_com) or (not exist(ps_setup)) then ps_setup=info.ps_stc
   endif
   xshow,group
RETURN
END

