;+
; Project     : SOHO - CDS
;
; Name        : XVALIDATE
;
; Purpose     : validates widget time strings
;
; Category    : operations, widgets
;
; Explanation :
;
; Syntax      : IDL> good=xvalidate(info,event)
;
; Inputs      : EVENT = event id of widget program calling XVALIDATE
;               INFO = structure with tags:
;               .WOPS1 - id of start time text widget
;               .WOPS2 - id of end time text widget
;               .OPS1  - current value of start time
;               .OPS2  - current value of end time
;
;
; Opt. Inputs : None
;
; Outputs     : GOOD = 1 if input times are valid (i.e, no weird
;               characters, and START time before END time)
;
; Opt. Outputs: None
;
; Keywords    : TRIM = # of characters to trim time string by
;             : TIME_CHANGE = 1 if time changed in either widget
;
; Common      : None
;
; Restrictions: None
;
; Side effects: None
;
; History     : Version 1,  21-Feb-1995,  D.M. Zarro.  Written
;
; Contact     : DZARRO@SOLAR.STANFORD.EDU
;-

 function xvalidate,info,event,trim=trim,time_change=time_change

;-- validate input times in TEXT widgets

 terr='Please ensure that START time less than or equal to END time'

 time_change=0
 old_start=anytim2utc(info.ops1,/ecs,/vms)
 old_end=anytim2utc(info.ops2,/ecs,/vms)
 do_trim=0
 if exist(trim) then if trim gt 0 then do_trim=1

 ok_start=1
 widget_control,info.wops1,get_value=in_string
 err=''
 stime_start=anytim2utc(in_string(0),err=err,/ecs,/vms) 
 if err ne '' then begin
  xack,err,group=event.top,/modal,/icon
  ok_start=0
 endif

 ok_end=1
 widget_control,info.wops2,get_value=in_string
 err=''
 stime_end=anytim2utc(in_string(0),err=err,/ecs,/vms)
 if err ne '' then begin
  xack,err,group=event.top,/modal,/icon
  ok_end=0
 endif

 good=(ok_start and ok_end)
 if good then begin
  ops1=utc2tai(stime_start)
  ops2=utc2tai(stime_end)
  if ops1 gt ops2 then begin
   xack,terr,group=event.top,/icon
   good=0
  endif 
 endif
  
 if good then begin
  tstart=stime_start
  tend=stime_end
  time_change=(ops1 ne info.ops1) or (ops2 ne info.ops2)
  info.ops1=ops1
  info.ops2=ops2
 endif else begin
  tstart=old_start
  tend=old_end
 endelse

 if do_trim then begin
  tstart=strmid(strtrim(tstart),0,trim)
  tend=strmid(strtrim(tend),0,trim)
 endif

 widget_control,info.wops1,set_value=tstart
 widget_control,info.wops2,set_value=tend

 return,good & end

