;***************************************************************************
;* 
;* PROCEDURE:     
;*      to_display_size,t90,ymat,newt90,newymat
;* 
;* DESCRIPTION:  
;*      This function resizes a data array to fit the actual diaplay pixels
;* 	available. It is used before calling the color spectrogram plot
;*      routines in order to speed up plotting by only plotting what would 
;*      actually be seen on the plot. Only the x-dimension is rescaled.
;*
;* INPUTS:       
;*      t90,ymat	: x-axis array and plot matrix
;* 
;* OUTPUT:	 
;*      newt90,newymat  : resized x-axis array and plot matrix
;*
;* CALLING SEQUENCE:
;*      to_display_size,t90,ymat,newt90,newymat
;*      
;* MODIFICATION HISTORY:       
;*      august 1996, written by R.Friedel 
;*
;***************************************************************************
pro to_display_size,t90,ymat,newt90,newymat

   normal_window=fltarr(2,2)
   normal_window(0,0)=!p.position(0)
   normal_window(1,0)=!p.position(1)
   normal_window(0,1)=!p.position(2)
   normal_window(1,1)=!p.position(3)

; find out no. of data points in x-direction
   result=size(ymat)
   x_data=result(1)

; find out actual display size in display coordinates
   plot_window=convert_coord(normal_window, /normal, /to_device)
   x_pixels=plot_window(0,1)-plot_window(0,0)

; if plot array is smaller than this, don't do anything
   if x_pixels ge x_data then begin
      newt90 = t90
      newymat=ymat
      return
   endif

; if plot array is larger, rescale down to actual display size. 
   new_xsize = x_pixels
   new_ysize = result(2)
   newymat=congrid(ymat,new_xsize,new_ysize,/interp)
   newt90=congrid(t90,new_xsize,/interp)


end
