; file commentsFor_batch.pro
;
; batch file to produce a set of commentsFor files for the
; papco tree structure.
;
; Refer to section 2.4.3. of the papco User's Manual
;
; R Friedel, September 1996

; compile required modules
.run string_functions
.run comments

;get the directory names of the papco distribution
papco_path    = papco_getenv('PAPCO_PATH')
papco_lib     = papco_getenv('PAPCO_LIB')
papco_modules = papco_getenv('PAPCO_MODULES')
papco_doc      =papco_getenv('PAPCO_DOC')
papco_doc_commentsFor=papco_doc+'commentsfor/'

print,papco_path
print,papco_lib
print,papco_modules
print,papco_doc_commentsFor

; run the commentsFor program
print,'running commentsFor for ',papco_path
commentsFor, papco_path, papco_doc_commentsFor+'papco'
print,'output files in ',papco_doc_commentsFor

print,'running commentsFor for ',papco_lib
commentsFor, papco_lib, papco_doc_commentsFor+'papco_lib'
print,'output files in ',papco_doc_commentsFor

print,'running commentsFor for ',papco_modules
commentsFor, papco_modules, papco_doc_commentsFor+'papco_modules'
print,'output files in ',papco_doc_commentsFor
