;******************************************************************************
;* PROCEDURE:    dealloc_lun
;* 
;* DESCRIPTION:  deallocate all lun's assigned with get_lun that are closed but
;*               have not been deallocated. Used primarily after save/restore,
;*               which uses get_lun internally but does not seem to free the
;*               units. Using a global close,/all is no good since we
;*               only want to make get_lun luns available,
;*               but don't want to indiscriminantly close all open files!
;*
;* INPUTS:       none
;*
;* OUTPUT:       none
;*
;* KEYWORDS:     QUIET  -  inhibts verbose output
;*
;* CALL:	 dealloc_lun
;*
;* HISTORY:      written September 1997, Reiner Friedel
;*****************************************************************************
pro dealloc_lun, QUIET=QUIET
  
   i=100
   free=bytarr(129)

   catch,error_status

   if error_status ne 0 then begin
      ;print,!err_string
      goto, next
   endif

   while i le 128 do begin
      get_lun,unit
      free(unit)=1
      if not keyword_set(QUIET) then print,'unit not used',unit
      next:
      i=i+1
   endwhile

; free all units not used
   units_not_used=where(free(100:128) eq 1,count)+100 
   if count ne 0 then begin
      for i=0,n_elements(units_not_used)-1 do  free_lun,units_not_used(i)    
   endif

   ;print, free(100:128)
   units_to_free=where(free(100:128) eq 0,count)+100

; check all units to free whether they are in use. Try to get a file position,
; and trap the error if that is not possible because the unit is not open!

   if count ne 0 then begin

   i=0

   catch,error_status

;if error occurs, file is not open and can be deallocated.

   if error_status ne 0 then begin 
      ;print,!err_string,i
      goto, next2
   endif

   while i lt n_elements(units_to_free) do begin
     point_lun,units_to_free(i)*(-1),position
     if not keyword_set(QUIET) then print,'still open -> keep', units_to_free(i)
     goto,next3  ; unit is open, do not deallocate
     if not keyword_set(QUIET) then print,'open:',units_to_free(i)
     next2:      ; error occured, unit closed, deallocate
     if not keyword_set(QUIET) then print,'closed -> deallocated', units_to_free(i)
     free_lun,units_to_free(i)
     next3:
     i=i+1     
   endwhile
  
   endif else if not keyword_set(QUIET) then print,'No get_lun units allocated'

;stop

end
