;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; A collection of mathematical functions, useful for f.ex. curvefit
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

function dblexp,x,p

   return,p(0)*exp(-x/p(1))+p(2)*exp(-x/p(3))

end

function singexp,x,p
   return,p(0)*exp(-x/p(1))
end

; PRO dblexp, X, A, F, pder

; ;; A =[a1,e1,a2,e2]
; ;; F=a1*exp(x*e1)+a2*exp(x*e2)

;   e1x = exp(A[1]*x)
;   e2x = exp(A[3]*X)
;   F = A[0]*e1x+ A[2]*e2x

;   IF n_params() GE 4 THEN $
; pder = [[e1x], [A[0]*X*e1x], [e2x], [A[2]*X*e2x], [replicate(1.0, n_elements(X))]]

; END

; PRO gfunct_sing, X, A, F, pder
; ;******************************************
; ; Define the function  used as the assumed  X-ray spectrum
; ; A(0)=A0_1
; ; A(1)=E0_1
; ;
; ;******************************************
; ; print,'(from gfunc_sing)'
; ; print,'A0_1',A(0)
; ; print,'E0_1',A(1)

;     a_t=strmid(strtrim(string(A),2),0,4)
;     if ((a_t(0) eq '?.00') or (a_t(1) eq '?.00')) then begin
;       a(0:1)=0  ; set to value that is NOT valid
 
;       goto, out
;     endif

;     bx = A(0)*EXP(-X/A(1))
;     F =  bx 

;     d1= EXP(-X/A(1) )				  ;  dF/dA(0)
;     d2= (A(0)*X*EXP(-X/A(1)))/( A(1)^2.)	  ;  dF/dA(1)


;     IF N_PARAMS() GE 4 THEN $
;     	pder= [[d1],[d2]]

;     out:      ;return a(0:3)= 0 if '?.00000'
; END

; PRO gfunct, X, A, F, pder
; ;******************************************
; ; Define the function  used as the assumed  X-ray spectrum
; ; A(0)=A0_1
; ; A(1)=E0_1
; ; A(2)=A0_2
; ; A(3)=E0_2
; ;
; ;******************************************
; ; print,'(from gfunc)'
; ; print,'A0_1',A(0)
; ; print,'E0_1',A(1)
; ; print,'A0_2',A(2)
; ; print,'E0_2',A(3)


;     a_t=strmid(strtrim(string(A),2),0,4)
;     if ((a_t(0) eq '?.00') or (a_t(1) eq '?.00') or  (a_t(2) eq '?.00') or (a_t(3) eq '?.00')) then begin
;       a(0:3)=0  ; set to value that is NOT valid
 
;       goto, out
;     endif

;     bx = A(0)*EXP(-X/A(1))
;     cx=  A(2)*EXP(-X/A(3))
;     F =  bx + cx

;     d1= EXP(-X/A(1) )				  ;  dF/dA(0)
;     d2= (A(0)*X*EXP(-X/A(1)))/( A(1)^2.)	  ;  dF/dA(1)
;     d3= EXP(-X/A(3) )				  ;  dF/dA(2)
;     d4= (A(2)*X*EXP(-X/A(3)))/( A(3)^2.)	  ;  dF/dA(3)


;     IF N_PARAMS() GE 4 THEN $
;     	pder= [[d1],[d2],[d3],[d4]]
    	
 
;     out:      ;return a(0:3)= 0 if '?.00000'
;  END

;; function for fitting pitch angle distributions from MPA and SOPA on
;; LANL satellites

FUNCTION pa_func, x, p
  d2r = !dpi/180d
  return, p(0)*(sin(x*d2r))^p(1) +p(2)
END 

FUNCTION pa_cust_func, x, p
;  d2r = !dpi/180d

;  lim = 7
;  result = fltarr(n_elements(x))  
;  IF min(x) LT lim THEN BEGIN 
;     ind = where(x LT lim)
;     result(ind) = (p(0)*(sin(x(ind)*p(1)*!dtor+p(2))^p(3))+p(4))*sin(x(ind)*90/lim*!dtor)
;  ENDIF 
;  IF max(x) GT 180-lim THEN BEGIN 
;     ind = where(x GT 180-lim)
;     result(ind) = ( p(0)*(sin(x(ind)*p(1)*!dtor+p(2))^p(3))+p(4))*sin(((180-x(ind))*90/lim)*!dtor)
;  ENDIF 
;  ind = where(x GT lim AND x LT 180 - lim, cnt)
;  IF cnt GT 0 THEN result(ind) =
;  p(0)*(sin(x(ind)*p(1)*!dtor+p(2))^p(3))+p(4)

;  return, p(0)*(sin(x*p(1)*!dtor+p(2))^p(3))+p(4)
;  return, p(0)*sin(p(1)*x*!dtor+p(2))^p(3)+p(4)*sin(p(5)*x*!dtor+p(6))^p(7)
  return, p(0)*sin(x*!dtor)^p(1)+p(2)*sin(x*!dtor)^p(3)
END 

FUNCTION str_line, x, p
  return, p(0)+x*p(1)
END 


FUNCTION maxwellian,x,p

   return,p(0)*x*exp(-x/p(1))

end

FUNCTION kappafun,x,p

 return,p(0)*(1+x^2/p(1))^(-p(2)-1)

end 
