;***************************************************************************
;***************************************************************************
;* 
;* FILE:	 
;*      get_new_button.pro
;* 
;* DESCRIPTION:  
;*      Returns the bitmap for a new button
;*
;* OVERVIEW:
;*	FUNCTION get_new_button, BATCH_BUTTON=BATCH_BUTTON
;*	
;* NEEDS:
;*      none
;*
;* COMMON VARIABLES:
;*      none
;*
;* MODIFICATION HISTORY:       
;*     may 1996, written by R. Friedel 
;***************************************************************************
;***************************************************************************
 
;***************************************************************************
;*
;* FUNCTION:     
;*       FUNCTION get_new_button, BATCH_BUTTON=BATCH_BUTTON
;* 
;* DESCRIPTION:  
;*      Returns the bitmap for a new button
;*
;* INPUTS:       
;*	none
;*
;* KEYWORDS:
;*	BATCH_BUTTON       :  BATCH_BUTTON bitmap array is returned           
;*      BMPUP              :  BMPUP bitmap array is returned
;*      BMPDOWN            :  BMPDOWN bitmap array is returned
;*      BMP_SHRINK         :  BMP_SHRINK bitmap array is returned
;*      BMP_ENLARGE        :  BMP_ENLARGE bitmap array is returned
;*      BMP_OTHERS_ENLARGE :  BMP_OTHERS_ENLARGE bitmap array is returned
;*      BMP_OTHERS_SHRINK  :  BMP_OTHERS_SHRINK bitmap array is returned
;*
;* OUTPUT:	 
;*      -1	   :   if no keyword is set
;*      byte array :   bitmap of button
;*
;* CALLING EXAMPLE:
;*      user_button=get_new_button(\BATCH_BUTTON)
;*
;* MODIFICATION HISTORY:       
;*     may 1996, written by R. Friedel 
;***************************************************************************
FUNCTION get_new_button, $
    BATCH_BUTTON=BATCH_BUTTON, $
    BMPUP=BMPUP, BMPDOWN=BMPDOWN, $
    BMP_SHRINK=BMP_SHRINK, BMP_ENLARGE=BMP_ENLARGE, $
    BMP_OTHERS_ENLARGE=BMP_OTHERS_ENLARGE, BMP_OTHERS_SHRINK=BMP_OTHERS_SHRINK
                         

   IF KEYWORD_SET(BATCH_BUTTON) THEN BEGIN
     return, [ $
      [ 0b, 0b, 0b, 0b ], $
      [ 0b, 0b, 4b, 0b ], $
      [ 0b, 0b, 231b, 63b ], $
      [ 0b, 0b, 3b, 2b ], $
      [ 0b, 0b, 1b, 2b ], $
      [ 0b, 0b, 1b, 2b ], $
      [ 0b, 0b, 225b, 63b ], $
      [ 0b, 0b, 1b, 0b ], $
      [ 0b, 0b, 33b, 32b ], $
      [ 0b, 0b, 33b, 32b ], $
      [ 0b, 0b, 33b, 32b ], $
      [ 0b, 0b, 33b, 32b ], $
      [ 0b, 0b, 193b, 31b ], $
      [ 0b, 6b, 1b, 0b ], $
      [ 0b, 8b, 33b, 0b ], $
      [ 254b, 31b, 33b, 0b ], $
      [ 248b, 63b, 225b, 63b ], $
      [ 254b, 31b, 33b, 0b ], $
      [ 0b, 8b, 33b, 0b ], $
      [ 0b, 6b, 1b, 0b ], $
      [ 0b, 0b, 193b, 63b ], $
      [ 0b, 0b, 33b, 2b ], $
      [ 0b, 0b, 33b, 2b ], $
      [ 0b, 0b, 33b, 2b ], $
      [ 0b, 0b, 193b, 63b ], $
      [ 0b, 0b, 1b, 0b ], $
      [ 0b, 0b, 193b, 29b ], $
      [ 0b, 0b, 33b, 34b ], $
      [ 0b, 0b, 33b, 34b ], $
      [ 0b, 0b, 35b, 34b ], $
      [ 0b, 0b, 231b, 63b ], $
      [ 0b, 0b, 4b, 0b ]  $
     ]
   ENDIF

   IF KEYWORD_SET(BMPUP) THEN BEGIN
     return,[ $
    [ 0b, 0b ], $
    [ 0b, 0b ], $
    [ 128b, 0b ], $
    [ 192b, 1b ], $
    [ 224b, 3b ], $
    [ 240b, 7b ], $
    [ 192b, 1b ], $
    [ 192b, 1b ], $
    [ 192b, 1b ], $
    [ 192b, 1b ], $
    [ 192b, 1b ], $
    [ 192b, 1b ], $
    [ 192b, 1b ], $
    [ 0b, 0b ], $
    [ 0b, 0b ], $
    [ 0b, 0b ]  $
   ]
   ENDIF

   IF KEYWORD_SET(BMPDOWN) THEN BEGIN
     return,[ $
    [ 0b, 0b ], $
    [ 0b, 0b ], $
    [ 0b, 0b ], $
    [ 192b, 1b ], $
    [ 192b, 1b ], $
    [ 192b, 1b ], $
    [ 192b, 1b ], $
    [ 192b, 1b ], $
    [ 192b, 1b ], $
    [ 192b, 1b ], $
    [ 240b, 7b ], $
    [ 224b, 3b ], $
    [ 192b, 1b ], $
    [ 128b, 0b ], $
    [ 0b, 0b ], $
    [ 0b, 0b ]  $
  ]
   ENDIF

   IF KEYWORD_SET(BMP_ENLARGE) THEN BEGIN
     return,[ $
    [ 0b, 0b ], $
    [ 128b, 0b ], $
    [ 192b, 1b ], $
    [ 224b, 3b ], $
    [ 240b, 7b ], $
    [ 192b, 1b ], $
    [ 192b, 1b ], $
    [ 192b, 1b ], $
    [ 192b, 1b ], $
    [ 192b, 1b ], $
    [ 192b, 1b ], $
    [ 240b, 7b ], $
    [ 224b, 3b ], $
    [ 192b, 1b ], $
    [ 128b, 0b ], $
    [ 0b, 0b ]  $
  ]
   ENDIF

   IF KEYWORD_SET(BMP_SHRINK) THEN BEGIN
     return,[ $
    [ 0b, 0b ], $
    [ 240b, 7b ], $
    [ 224b, 3b ], $
    [ 192b, 1b ], $
    [ 192b, 1b ], $
    [ 192b, 1b ], $
    [ 192b, 1b ], $
    [ 192b, 1b ], $
    [ 192b, 1b ], $
    [ 192b, 1b ], $
    [ 192b, 1b ], $
    [ 192b, 1b ], $
    [ 192b, 1b ], $
    [ 224b, 3b ], $
    [ 240b, 7b ], $
    [ 0b, 0b ]  $
  ]
   ENDIF

   IF KEYWORD_SET(BMP_OTHERS_ENLARGE) THEN BEGIN
     return, [ $
    [ 128b, 0b ], $
    [ 192b, 1b ], $
    [ 224b, 3b ], $
    [ 128b, 0b ], $
    [ 128b, 0b ], $
    [ 224b, 3b ], $
    [ 192b, 1b ], $
    [ 128b, 0b ], $
    [ 0b, 0b ], $
    [ 224b, 3b ], $
    [ 128b, 0b ], $
    [ 128b, 0b ], $
    [ 128b, 0b ], $
    [ 128b, 0b ], $
    [ 128b, 0b ], $
    [ 224b, 3b ]  $
  ]
   ENDIF

   IF KEYWORD_SET(BMP_OTHERS_SHRINK) THEN BEGIN
     return,[ $
    [ 224b, 3b ], $
    [ 192b, 1b ], $
    [ 128b, 0b ], $
    [ 128b, 0b ], $
    [ 128b, 0b ], $
    [ 128b, 0b ], $
    [ 192b, 1b ], $
    [ 224b, 3b ], $
    [   0b, 0b ], $
    [ 224b, 3b ], $
    [ 128b, 0b ], $
    [ 128b, 0b ], $
    [ 128b, 0b ], $
    [ 128b, 0b ], $
    [ 128b, 0b ], $
    [ 224b, 3b ]  $
  ]
   ENDIF

   return, -1
END
