pro GIFFit, vname, pname, cname, XDISP=XDISP,START=start, STOP=stop,$
            XSIZE=XSIZE,YSIZE=YSIZE,LINESTYLE=LINESTYLE,COLOR=COLOR,$
            BACKGROUND=BACKGROUND,NOAUTOSCALE=NOAUTOSCALE,TITLE=TITLE,$
	    GIF=GIF

; Initialize common blocks used by CDAW s/w
@pltcmn
cdsinit
widsinit
plot_init

; Parse variable names
vnames = BreakStrArr(vname,DELIMITER=',')
vnums  = lonarr(N_ELEMENTS(vnames))

; Parse cdf filenames
cnames = BreakStrArr(cname,DELIMITER=',')

; Determine start time of data request
if (KEYWORD_SET(start)) then starttime=start $
else begin
  ierr = OPEN_CDF(pname,cnames(0))
  if (ierr eq -1) then begin
    print,"ERROR OPENING CDF FILE" & Return
  endif else begin
    ierr = Get_Times(starttime,temp)
    if (ierr eq -1) then begin
      print,"ERROR GETTING START TIME FROM 1ST CDF FILE" & Return
    endif
  endelse
endelse

; Determine stop time of data request
if (KEYWORD_SET(stop)) then stoptime=stop $
else begin
  ierr = OPEN_CDF(pname,cnames(N_ELEMENTS(cnames)-1))
  if (ierr eq -1) then begin
    print,"ERROR OPENING CDF FILE" & Return
  endif else begin
    ierr = Get_Times(temp,stoptime)
    if (ierr eq -1) then begin
      prin,"ERROR GETTING STOP TIME FROM LAST CDF FILE" & Return
    endif
  endelse
endelse

; Add the variable and all dependent variables to the CDAW common block
entry = ADD_WLENTRY(starttime,stoptime)
for i=0,N_ELEMENTS(vnames)-1 do begin
  vnums(i) = ADD_WLVAR(vnames(i),entry,-1,pname,cnames(0))
  if (vnums(i) eq -1) then begin
    print,"ERROR ACCESSING ",vnames(i)," METADATA" & Return
  endif
endfor

; Add all other CDF files to CDAW common block
for i=1,N_ELEMENTS(cnames)-1 do begin
  ierr = ADD_FILE(vnums(0),pname,cnames(i))
  if (ierr eq -1) then begin
    print,"ERROR ADDING ADDITIONAL FILES" & Return
  endif
endfor

; Setup CDAW plot common block
ierr  = quickplot(VARS=vnums)
if (ierr ne 0) then begin
  print,"ERROR DETERMINING PLOT SETUP" & Return
endif

; Set additional plot options based on KEYWORD PARAMETERS
wi=line_info.window_num
if (KEYWORD_SET(XSIZE)) then window_info(wi).default_panel_size(0)=XSIZE
if (KEYWORD_SET(YSIZE)) then window_info(wi).default_panel_size(1)=YSIZE
if (KEYWORD_SET(BACKGROUND)) then window_info(wi).bkground_color=BACKGROUND
if (KEYWORD_SET(TITLE)) then window_info(wi).profile(0).text=TITLE
if (KEYWORD_SET(LINESTYLE)) then begin
  line_info.axes(X).axis.line_style=LINESTYLE
  line_info.axes(Y).axis.line_style=LINESTYLE
  if LINESTYLE > 0 then line_info.axes(Y).axis.symbol_type = 3
endif
if (KEYWORD_SET(COLOR)) then begin
  line_info.axes(X).axis.line_color=COLOR
  line_info.axes(Y).axis.line_color=COLOR
endif
if (KEYWORD_SET(NOAUTOSCALE)) then line_info.axes(Y).axis.auto_scale=NO

; Determine output device
if (KEYWORD_SET(XDISP)) then papco_set_plot,'X' $
else papco_set_plot,'Z'

; Create the Plot
print,"CREATING PLOT..."
make_plot

; Create the GIF file
print,"CREATING GIF FILE..."
Plot_Image = TVRD()
if not (keyword_set(GIF)) then gif=vname+'.gif'
WRITE_GIF,gif,Plot_Image

; Clear allocated data space
Plot_Image=0
clearall_dataptrs

Return
end

