; test program to produce a GIFF file from a normal IDL graphic

pro make_giff,XDISP=XDISP,GIF=GIF

; Determine output device
if (KEYWORD_SET(XDISP)) then papco_set_plot,'X' $
else papco_set_plot,'Z'

; Create the Plot
print,"CREATING PLOT..."
make_plot

; Create the GIF file
if (keyword_set(GIF)) then begin
  print,"CREATING GIF FILE..."
  Plot_Image = TVRD()
  gif='example.gif'
  WRITE_GIF,gif,Plot_Image
endif

end

pro make_plot

x=findgen(100)

plot,x,sin(6.8*x/100)
oplot,x,cos(6.8*x/100)

end
