;******************************************************************************
;* PROCEDURE:   mission_createOrbitInfo 
;* 
;* DESCRIPTION: for all MISSION-ephemeris-files in the directory MISSION_EPH, 
;*	        orbit-infos are created and written to the file  
;*              $MISSION_EPH/orbits.info 
;*
;* INPUTS:      none
;* 
;* OUTPUT:	none
;*
;* CALLING SEQUENCE: mission_createOrbitInfo
;* 
;* MODIFICATION HISTORY: December 1997, written by R. Friedel 
;******************************************************************************
PRO mission_createOrbitInfo

COMMON mission_ephem, mission_ephem

; search for the MISSION-data-files. Use this code to get a list of all the
; ephemeris files available for MISSION. Replace with correct file template
; for your files in findfile below.

message, 'Compiling list of all MISSION ephemeris files...',  /cont
mission_path=papco_getenv('MISSION_EPH')
allMISSIONFiles=findfile(mission_path+'MISSION_EPH_*.DAT')
print, '  ...found', N_ELEMENTS(allMISSIONFiles), ' ephemeris-files'

; Depending on your MISSION ephemeris files, loop through them to find orbit
; start and end times. One way of doing this is to construct an array of
; radial distance. Max. of radius are then apogee times, Min perigee times.


;     Enter user code at this point
;     to construct an array of orbit start and end times
;     Assume there are ndat orbits, then continue:


; create a MISSION_ORBIT_INFO-structure and create an array of those

tmp=papco_getOrbitInfoStruct()	  
orbitInfo=replicate(tmp, ndat)

FOR i=0l,ndat do BEGIN 
          ;
          ; format your orbit start /end times such that
          ; i      = orbit number
          ; day_oy = is the day of year of start of orbit
          ; year   = is the year of start of orbit
          ; xut1   = is the no of sec from the start day of the start of orbit
          ; xut2   = is the no of sec from the start day of the end of orbit
          ; 
          ; Its up to you to define orbits from apogee to apogee or 
          ; from perigee to perigee
          ;
          ; save the data in the orbitInfo-structure
          ;
          orbitInfo(i).number=i	   
          orbitInfo(i).day=day_oy
          orbitInfo(i).year=year
          orbitInfo(i).xut1=ap_time
          orbitInfo(i).xut2=ap_time + 63120l
          orbitInfo(i).xdata=0 ;dummy, don't use, here for old compatibility
          orbitInfo(i).ydata=0 ;dummy, don't use, here for old compatibility
      ENDFOR 

; write the orbits.info-file

 result=papco_writeOrbitInfo('MISSION', orbitInfo)
 IF result EQ 'OK' THEN $
      message, 'OrbitInfo successfully created.', /cont $
 ELSE $
      print, result
 RETURN

END; (mission_createOrbitInfo)
