function papco_graph_monitor::Init, $
	idMessage=idMessage, idProgress=idProgress, idDraw=idDraw, idCancel=idCancel, title=title, $
	progress_color=progress_color, background_color=background_color, $
	dposition=dposition, drawWindow=drawWindow
  if ( self->papco_monitor::Init() ) then begin
      if n_elements(title) eq 0 then title='progress monitor'

      if n_elements(idMessage) eq 0 then idMessage=0
      if n_elements(idProgress) eq 0 then idProgress=0
      if n_elements(idDraw) eq 0 then idDraw=0
      if n_elements(idCancel) eq 0 then idCancel=0

      if idMessage eq 0 and $
      	idProgress eq 0 and $
        idDraw eq 0 and $
      	idCancel eq 0 then begin
      	  self.myUi=1
      endif else begin
          self.myUi=0
      endelse

      if ( self.myUi ) then begin
         pbase= widget_base( title=title, /column )
          base= widget_base( pbase, /column )
          self.idBase= pbase
          self.idMessage= widget_label( base, value='                                            ', xsize=300 )
          self.idProgress= widget_label( base, value='                                           ', xsize=300 )
          if ( n_elements( drawWindow ) ne 1 ) then $
          	self.idDraw= widget_draw( base, xsize=300, ysize=4 )
          self.idCancel= widget_button( base, value='cancel' )
      endif else begin
          self.idMessage= idMessage
          self.idProgress= idProgress
          self.idDraw= idDraw
          self.idCancel= idCancel
      endelse

      if n_elements(progress_color) eq 0 then $
        self.progressColor= self->get_progress_color() else $
      	self.progressColor= progress_color
      if n_elements(background_color) eq 0 then $
        self.backgroundColor= self->get_background_color() else $
      	self.backgroundColor= background_color
      if n_elements(dposition) eq 4 then self.dposition=dposition else self.dposition[0]=-1
      if n_elements(drawWindow) eq 1 then self.drawWindow= drawWindow else self.drawWindow=-1

      if self.myui then begin
          oldw= !d.window
          widget_control, pbase, /realize
          wset, oldw
      end
      self->updateUI
      return, 1
  endif else begin
      return, 0
  endelse
end


function papco_graph_monitor::get_progress_color
    ;; find the closest color to blue
	tvlct, /get, rr, gg, bb
	x= min( abs( rr-0 ) + abs( gg-0 ) + abs( bb-255 ), imin )
	return, imin
end

function papco_graph_monitor::get_background_color
    ;; find the closest color to gray
	tvlct, /get, rr, gg, bb
	x= min( abs( rr-230 ) + abs( gg-230 ) + abs( bb-230 ), imin )
	return, imin
end

pro papco_graph_monitor::updateUI
  if ( self.idProgress ne 0 ) then begin
      if ( not widget_info( self.idProgress, /valid ) ) then return
      msg= strtrim(long(self.progress),2)+' of '+strtrim(self.taskSize,2)
      widget_control, self.idProgress, get_value= curmsg
      if ( curmsg[0] ne msg ) then $
        widget_control, self.idProgress, $
        set_value=strtrim(long(self.progress),2)+' of '+strtrim(self.taskSize,2)
  endif

  if ( widget_info( self.idMessage, /valid ) ) then begin
      widget_control, self.idMessage, get_value=message
      if ( message[0] ne self.mmessage ) then $
        widget_control, self.idMessage, set_value=self.mmessage
  endif

  if ( self.drawWindow eq -1 ) then begin
     if not widget_info( self.idDraw, /valid ) then return
     if not widget_info( self.idDraw, /realized ) then return
     widget_control, self.idDraw, get_value= x
     self.drawWindow=x
  endif

  if ( widget_info( self.idDraw, /valid ) ) then begin
  	 drawingX= !d.name eq 'X' or !d.name eq 'WIN'
     if ( drawingX eq 0 ) then begin
       oldDevice= !d.name
       papco_set_plot, 'X'
     endif


     oldw= !d.window
     wset, self.drawWindow

     if ( self.dposition[0] eq -1 ) then begin
        width= !d.x_size
        height= !d.y_size
        self.dposition=[0,0,width,height]
     endif

	  width= self.dposition[2]-self.dposition[0]
	  xx= self.dposition[0] + [ 0, width*self.progress/self.taskSize, width-1 ]
	  yy= [ self.dposition[1], self.dposition[3]-1 ]
	  polyfill, /device, color=self.backgroundColor, $
	     xx[ [ 1,1,2,2,1 ] ], $
	     yy[ [ 0,1,1,0,0 ] ]
	  plots, /device, color=self.progressColor, $
		 xx[ [ 0,0,2,2,0 ] ], $
	     yy[ [ 0,1,1,0,0 ] ]
	  polyfill, /device, color=self.progressColor, $
	     xx[ [ 0,0,1,1,0 ] ], $
	     yy[ [ 0,1,1,0,0 ] ]

	  wset, oldw
	  if ( drawingX eq 0 ) then begin
	      set_plot, oldDevice
	  endif
 endif

end

pro papco_graph_monitor::setCancelled, p
  self->papco_monitor::setCancelled, p
  widget_control, self.idCancel, set_value='cancel', sensitive=1
end

function papco_graph_monitor::isCancelled
  if widget_info(  self.idCancel, /valid ) then begin
    w= widget_event( self.idCancel, /nowait )
    if ( tag_names(w,/structure_name) eq 'WIDGET_BUTTON' ) then begin
      self.isCancelled=1
      widget_control, self.idCancel, set_value='cancel', sensitive=0
    endif
  endif
  return, self.isCancelled
end

pro papco_graph_monitor::setProgress, p
  if widget_info(  self.idCancel, /valid ) then widget_control, self.idcancel, sensitive=1
  self->papco_monitor::setProgress, p
  self->updateUI
end

pro papco_graph_monitor::setMessage, p
  self->papco_monitor::setMessage, p
  self->updateUI
end

pro papco_graph_monitor::finished
  if widget_info(  self.idCancel, /valid ) then widget_control, self.idcancel, sensitive=0
  if widget_info( self.idMessage, /valid ) then widget_control, self.idMessage, set_value=''

  if ( self.myUi ) then begin
  	widget_control, self.idbase, /destroy
  endif
end

pro papco_graph_monitor__define
  struct= { papco_graph_monitor, $
    idBase:0L, $
    idDraw:0L, $
  	drawWindow:-1L, $
  	progressColor:0, $
  	backgroundColor:0, $
  	dposition:intarr(4), $
  	myUI:0, $ ;; 1 if I created the UI
  	idMessage:0L, $
  	idProgress:0L, $
  	idCancel: 0L, $
  	inherits papco_monitor }
end
