function papco_monitor::Init, a, b, c
  self.taskSize=100
  return, 1
end

function papco_monitor::isCancelled
  return, 0
end

pro papco_monitor::setCancelled, p
  self.isCancelled=p
end

pro papco_monitor::setProgress, p
  self.progress=p
end

pro papco_monitor::finished
end

pro papco_monitor::setTaskSize, p
  self.taskSize= p
end

pro papco_monitor::setMessage, p
  self.mmessage= p
end

function papco_monitor::newSubtaskMonitor, low, high
  return, obj_new( 'papco_subtask_monitor', self, low, high )
end

function papco_monitor::toString
  return, strtrim(long(self.progress),2) + ' of ' +strtrim(self.taskSize,2)+': '+self.mmessage
end

pro papco_monitor::test
  self->setTaskSize, 1000
  for i=5,999 do begin
     wait, 0.01
     self->setProgress, i
     if ( i mod 10 eq 0 ) then begin
         self->setMessage, strtrim(i,2)+' iterations'
     endif
     if ( self->isCancelled() ) then break
  end
end

pro papco_monitor__define
   struct= { papco_monitor, $
    taskSize:100L, $
   	progress:0., $
   	isCancelled:0, $
   	mmessage:'' $
   }
end
