function papco_subtask_monitor::Init, parent, low, high
   if ( self->papco_monitor::Init() ) then begin
      self.parent= parent
      self.low= low
      self.high= high
      return, 1
   endif else begin
      return, 0
   endelse
end

pro papco_subtask_monitor::setProgress, p
    self->papco_monitor::setProgress, p
    parent_progress= self.low + ( self.high-self.low ) * float(p) / self.taskSize
    self.parent->setProgress, parent_progress
end

function papco_subtask_monitor::isCancelled
   return, self.parent->isCancelled()
end

pro test
    mon= obj_new( 'papco_graph_monitor' )
    mon->setTaskSize, 10
     for i=0,9 do begin
      mon2= mon->newSubtaskMonitor( i, i+1 )
      mon2->setTaskSize, 30
      for j=0,29 do begin
          mon3= mon2->newSubtaskMonitor( j, j+1 )
          mon3->setTaskSize, 5
          for k=0,4 do begin
          	  wait, 0.01
              mon3->setProgress, k
              if ( mon3->isCancelled() ) then break
          endfor
          if ( mon2->isCancelled() ) then break
      endfor
      if ( mon->isCancelled() ) then break
  endfor
end

pro papco_subtask_monitor__define
  struct= { papco_subtask_monitor, $
  	 parent: obj_new(), $
     low:0L, $
     high:0L, $
     inherits papco_monitor }
end
