;******************************************************************************
;* DESCRIPTION:  Sets up commons for ONERA-DESp library, checks
;*               operating system and availablility of libraries
;******************************************************************************
PRO papco_onera_init, VERBOSE = VERBOSE

COMMON get_error, get_err_no, get_err_msg
COMMON onera, ext_field_names, onera_ok

ext_field_names = ['none', $
                   'Mead_Fairfield_1975', $
                   'Tsyganengo_short_1987', $
                   'Tsyganengo_long_1987', $
                   'Tsyganenko_1989c', $
                   'Olson_Pfitzer_quiet_1977', $
                   'Olson_Pfitzer_dynamic_1988]', $
                   'Tsyganenko_1996', $
                   'Ostapenko_Maltsev_1997', $
                   'Tsyganenko_2001', $
                   'Tsyganenko_2001_storm']

IF keyword_set(VERBOSE) THEN verbose=1 ELSE verbose=0
IF keyword_set(onera_ok) THEN onera_ok = onera_ok ELSE onera_ok = 0
IF onera_ok THEN return

;setup onera shareable object location. This test for current
;operating system and IDL version and returns error if not available
lib = 'OK'
IF lib EQ '' THEN BEGIN
    get_err_msg = 'Onera library not compiled'
    message, get_err_msg, /info
    get_err_no = 1 & onera_ok = 0 & return
ENDIF

onera_ok = 1


END
