;; minimally implement file_delete for idl 5.4.

pro papco_file_delete1, file, $
                        allow_nonexistent=allow_nonexistent, $
                        verbose=verbose, $
                        quiet=quiet
  
  if ( n_params() gt 1 ) then begin
      message, 'only one parameter supported', /cont
  endif
    
  if ( keyword_set(allow_nonexistent) ) then begin
      f= findfile( file ) 
      if ( f[0] ne '' ) then begin
          if ( keyword_set(verbose) ) then message, 'deleting '+file, /cont
          file_delete, file, quiet=quiet              
      endif 
  endif else begin
      if ( keyword_set(verbose) ) then message, 'deleting '+file, /cont
      file_delete, file, quiet=quiet  
  endelse          

end

pro papco_file_delete, files, $
                       _extra=e
  if ( !version.release ge 5.5 ) then begin
      file_delete, files, _extra=e
  endif else begin
      for i=0, n_elements(files)-1 do begin
          papco_file_delete1, files[i], _extra=e
      endfor
  endelse
end
