;******************************************************************************
;* FUNCTION:     papco_get_libname
;*
;* DESCRIPTION:  return the correct external library name for the
;*               current operating system.
;*
;* KEYWORDS:     VERBOSE  - give verbose diagnostic output
;*               ONERA    - return ONERA/DESP library from S. Bourdarie 
;*
;* INPUTS:       none
;*
;* OUTPUT:       library name string
;*               empty strin if not found or not available for opsys.
;*
;* HISTORY:      written September 2004, Reiner Friedel
;******************************************************************************
FUNCTION papco_get_libname, ONERA = ONERA

lib_name = ''

if keyword_set(ONERA) then begin
    dir = getenv('PAPCO_LIB')+'/onera/'
    case !VERSION.OS_NAME of
        'Solaris': lib_name = dir + 'onera_desp_lib_sunos.so'
        'linux': lib_name = dir + 'onera_desp_lib_linux.so'
        else: lib_name = ''
    endcase
endif

return,lib_name

END 
