;******************************************************************************
;* PROCEDURE: panelset, panel, TOTAL=TOTAL
;* 
;* DESCRIPTION:  
;*       used by papco system. 
;*
;*       reads the IDL graphics variable !d.name which is set by the
;*       routine set_plot from the IDL prompt. set_plot='x', the default
;*       when starting IDL, selects and X-window display. set_plot='ps' selects
;*       postscript output. Here display and plot window size are set.
;*
;* INPUTS:       
;*	 panel:  panel vector passed from PAPCO. Sets the
;*               position and height of the panel.
;*               panel(0): number of the panel (numbered
;*                         from 0 from the bottom of the  page up
;*               panel(1): total number of panels
;*               panel(2): height of a panel in multiples of panel height 
;*                         given by viewport divided by number of panels. 
;*               Sets the global IDL system variable !p.position
;*
;* KEYWORDS:
;*	TOTAL:   if set, !p.position is set to the normal coords
;*               of the total area of the panel, not just the plot area.
;*      AXIS:    leaves room at bottom of panel for extra axis
;*
;* OUTPUT:	 
;*      none
;*
;* CALLING EXAMPLE:
;*      panelset, panel
;*         
;* MODIFICATION HISTORY:       
;*      April 1998, written by R. Friedel
;******************************************************************************
pro panelset, panel, TOTAL=TOTAL, AXIS=AXIS
  
COMMON PLOT_COMPOSER, widgetData

plotno = widgetData.current_plotNr
plotinfo = widgetData.plotInfos(plotno)

widgetData.panelset = panel
  
; set up start positon of total plot area and size of actual plot area
; in relative coordinates. If numbering is chosen, make more room at
; left of plot.
  if widgetData.default_numbering eq 0 then num_space=0.020 else num_space=0
  rel_x_start=0.125+num_space
  rel_x_width=0.675-num_space
  
  rel_y_start=0.100
  rel_y_height=0.875
  IF NOT plotinfo.nogap THEN $ ;to leave a gap between panels
    rel_y_draw_height_factor=0.95 ELSE  rel_y_draw_height_factor = 1.0 
  rel_p_height=rel_y_height/panel(1)
  
  if KEYWORD_SET(TOTAL) then begin
    rel_x_start=0.0
    rel_x_width=1.0
    rel_y_draw_height_factor=1
  endif      
  
; adjust the size of the actual plot area (excluding annotation)
; depending on the settings of defaultplot_size.
  rel_x_width =rel_x_width *widgetData.default_plot_size(0)/100
  rel_p_height=rel_p_height*widgetData.default_plot_size(1)/100    

  rel_x_end=rel_x_start+rel_x_width

  diff = abs(rel_p_height - rel_y_height/panel(1)) * panel(1)
  rel_y_start = rel_y_start+diff

  pypos1=rel_y_start+rel_p_height*panel(0)
  pypos2=rel_y_start*rel_y_draw_height_factor+rel_p_height*(panel(0)+panel(2))

  ;print, rel_y_draw_height_factor,pypos1, pypos2
  
  if KEYWORD_SET(TOTAL) then begin
    if panel(0) eq 0 then pypos1= pypos1 else $
      pypos1=pypos1-(0.05*rel_y_start)
    if panel(1) eq panel(0)+panel(2) then pypos2=1.0
  endif
  
  if KEYWORD_SET(AXIS) then begin
    chrs=convert_coord(!D.x_ch_size,!D.y_ch_size,/device,/to_normal)
    chrs=chrs*!P.CHARSIZE
    pypos1=pypos1+chrs(1)*axis*1.0+abs(!P.TICKLEN)
  endif  
  
  !p.position=[rel_x_start, pypos1, rel_x_end, pypos2]

END 
