;******************************************************************************
;*  NAME:        papco_add_mag
;*
;*  DESCRIPTION: adds magnetic field model coords to a given ephemeris
;*               file - keeps adding structures. 
;*               uses get_mag_onera - onera fortran library
;*
;*  INPUT:       cor_type  -  coordinate type of input ephemeris
;*               cor_sys   -  coordinate system of input ephemeris
;*               control   -  the module's control structure
;*
;*  OUTPUT:      
;*
;*  DATE:        July 2003
;*
;*  AUTHOR:      R. Friedel
;******************************************************************************
PRO papco_add_mag, control, cor_type, cor_sys, $
                   eph_struct_flname, new_struct_name, $
                   tai, pos, input_data, error

COMMON plot_composer, widgetdata
COMMON get_error, get_err_no, get_err_msg
COMMON onera, ext_field_names, onera_ok

error = 0

;remove old mag model tags (pre stat / dyn).
tags=tag_names(input_data(0))
idx = where(strmid(tags, 0, 5) EQ 'MODEL', c)
IF c NE 0 THEN BEGIN
    len = strlen(tags(idx))
    idx_len = where(len EQ 9, c)
    IF c EQ 0 THEN GOTO, no_old_structs
    idx_del = idx(idx_len)
    message, 'Removing old mag model structure:', /info
    error = 1
    print, '  ', tags(idx_del)
    ;make the new structure
    FOR i = 0,  n_elements(tags)-1 DO BEGIN
        idx = where(idx_del EQ i, c)
        IF c EQ 1 THEN  CONTINUE 
        IF i EQ 0 THEN dummy = create_struct(tags(i), input_data(0).(i)) $
        ELSE dummy = create_struct(dummy, tags(i), input_data(0).(i))
    ENDFOR
    n_dat = n_elements(input_data)
    input_data_new = replicate(dummy, n_dat)
    struct_assign, input_data, input_data_new
    input_data = input_data_new
    eph_struct = input_data(0)
    save, file = eph_struct_flname, eph_struct
ENDIF 
no_old_structs:

new_struct_name=''
get_err_no=0 & get_err_msg='Mag Model Coords Added O.K.'

;return if only internal model coords are requested.
if control.orig eq 0 then return

>>>>>>> 1.6
intmod = 0 ; IGRF only supported here for now
extmod = control.EXTERNAL_MODEL
mag_dyn = control.MAG_DYN
IF mag_dyn THEN dyn_str = 'DYNA' ELSE dyn_str = 'STAT'

new_struct_name = 'MODEL_'+varprt(intmod)+'_'+varprt(extmod)+'_'+dyn_str
l_arr = fltarr(9) & l_arr(*) = -99
new_struct = create_struct(name='MAG_MOD_INFO', 'L', 0.0, 'LSTAR', l_arr, $
                           'MLT', 0.0, 'MLAT', 0.0, $
                           'B1', 0.0, 'B2', 0.0,'B3', 0.0, 'Bmin', 0.0)

;get list of tags for models that had been done before
restore, file = eph_struct_flname 

need_tags = tag_names(eph_struct)
tags=tag_names(input_data(0))

n = 0 & todo_tags = ''

;get set of pitch angles to do for L* calc
pitch_names = papco_make_choice_names(control.pitch_proc_info)
npa = n_elements(pitch_names) & set = bytarr(npa)
FOR i = 0, npa-1 DO IF (control.pitch_proc AND 2^i) EQ 2^i THEN set(i) = 1 $
                                                           ELSE set(i) = 0
;check the MAG_PROC variable to see what processing is needed
CASE control.MAG_PROC OF
    '0': BEGIN                  ;Current+Previous
        ;see if we have to add the currently selected mag field.
        idx = where(new_struct_name EQ tags, c)
        IF c EQ 0 THEN BEGIN
            todo_tags = new_struct_name
            n = n+1
        ENDIF 
        ;print, '1:', n
        ;see if we have any missing tags
        FOR i = 0, n_elements(need_tags)-1 DO BEGIN 
            idx = where(need_tags(i) EQ tags, c)
            IF c EQ 0 THEN BEGIN
                IF (n EQ 0) THEN todo_tags = need_tags(i) $
                ELSE todo_tags = [todo_tags, need_tags(i)]
                n = n+1
                ;print, '2:', n
            ENDIF ELSE BEGIN    ;for already existing tags, check for L(PA)
                IF strmid(need_tags(i), 0, 5) EQ 'MODEL' THEN BEGIN
                    FOR j = 0, npa-1 DO BEGIN
                        IF NOT set(j) THEN CONTINUE
                        IF control.L_CALC EQ 0 THEN $
                           lvals = input_data.(i).L ELSE $
                           lvals = input_data.(i).LSTAR(j)
                        idx = where(lvals NE -99, c2)
                        IF c2 EQ 0 THEN BEGIN ;add to todo list
                            IF (n EQ 0) THEN todo_tags = need_tags(i) $
                            ELSE todo_tags = [todo_tags, need_tags(i)]
                            n = n+1
                            break
                        ENDIF
                        ;print, '3:', n
                    ENDFOR 
                ENDIF 
            ENDELSE 
        ENDFOR
    END
    '1': BEGIN                  ;Current only
        IF control.orig EQ 1 THEN BEGIN
            ;see if we have to add the currently selected mag field.
            idx = where(new_struct_name EQ tags, c)
            IF c EQ 0 THEN BEGIN
                idx = where(new_struct_name EQ todo_tags, c)
                IF c EQ 0 THEN BEGIN 
                    IF (n EQ 0) THEN todo_tags = new_struct_name $
                    ELSE todo_tags = [todo_tags, new_struct_name]
                    n = n+1
                ENDIF 
            ENDIF ELSE BEGIN
                ;if L* is selected, check if for current choice of model 
                ;it needs to be done.
                IF control.l_calc EQ 1 THEN BEGIN
                    idx2 = where(new_struct_name EQ tags, c)
                    idx = where(input_data.(idx2(0)).LSTAR(0) NE -99, c2)
                    IF c2 EQ 0 THEN BEGIN 
                        IF (n EQ 0) THEN todo_tags = new_struct_name $
                        ELSE todo_tags = [todo_tags, new_struct_name]
                        n = n+1
                    ENDIF 
                ENDIF     
            ENDELSE 
        ENDIF        
    END    
    '2': BEGIN                  ;Force Current
        todo_tags = [new_struct_name] & n = 1 
    END        
    '3': BEGIN ;Force Current+Previous
        todo_tags = [new_struct_name]
        modpos = strpos(need_tags, 'MODEL_') & idx = where(modpos NE -1, c)
        IF c NE 0 THEN todo_tags = [need_tags(idx),todo_tags]
        n = n_elements(todo_tags) 
    END
ENDCASE 

IF n EQ 0 THEN BEGIN
    message, 'No Mag Coords to do', /cont
    IF error EQ 1 THEN return ;only deleted tags from datat, need to re-save
    error = 2   ;no new structures added to input_data
    return      ;no mag field coords to do
ENDIF 

message,'Models to do:', /info
FOR i = 0, n-1 DO print, '       ', todo_tags(i)

FOR i = 0, n-1 DO BEGIN ;loop through all mag coords todo
    
    ;get intmod,extmod from model name tags
    intmod = fix(strmid(todo_tags(i), 6, 1))
    extmod = fix(strmid(todo_tags(i), 8, 1))

    ;add new structure tag to array if it does not exist
    idx = where(tags EQ todo_tags(i), c)
    IF c EQ 0 THEN BEGIN 
        message, 'Adding new model tag: '+todo_tags(i), /info
        dummy2=create_struct(input_data(0),todo_tags(i),new_struct)
        dummy3=replicate(dummy2,n_elements(input_data)) 
        ;fill new array with copies of existing array
        struct_assign, input_data, dummy3, /NOZERO
        input_data=temporary(dummy3)
    ENDIF

    ;get the index of the new mag coords tag
    tags=tag_names(input_data(0)) 
    index=where(tags eq todo_tags(i))
    new_idx=index(0)  
    ndat =  n_elements(input_data)

    ;get mag coords (from ONERA-DESP library) 
    ;tai and pos is passed in, so is cor_type and cor_sys

    IF control.l_calc EQ 1 THEN BEGIN
        do_lstar = 1 
        message,'doing L, L*, MLT, B, B_min for ' + todo_tags(i), /cont
        out_str = ''
        FOR i = 0, npa-1 DO IF set(i) THEN out_str = out_str+pitch_names(i)+' '
    ENDIF ELSE BEGIN
        do_lstar = 0
        message,'doing L, MLT, B, B_min for '+todo_tags(i), /cont
        set(0) = 1; do only for one pitch angle, all have same L  here
    ENDELSE 
    
    todo_set = set
    IF control.MAG_PROC LE 1 THEN BEGIN 
        ;check if some L* pitch calc have been done
        FOR i = 0, npa-1 DO BEGIN
            IF NOT set(i) THEN continue
            idx = where(input_data.(new_idx).LSTAR(i) NE -99, c3)
            IF c3 NE 0 THEN todo_set(i) = 0
        ENDFOR      
    ENDIF 

    pa_idx = where(todo_set EQ 1, npa)
    pitch = long(pitch_names(pa_idx)) ;pitch angles to do.
    pitch_str = ''
    FOR i = 0, npa-1 DO pitch_str=pitch_str+' '+varprt(pitch_names(pa_idx(i)))
    message, 'for pitch angles:' + pitch_str, /info

    now = systime(1)   ;work out time taken for external call

    get_mag_onera, tai, pos, cor_type, cor_sys, $
                   b1, b2, b3, bmin, lm, lstar, mlt, mlat, error, $
                   INTMOD=INTMOD, EXTMOD = EXTMOD, MAG_DYN = mag_dyn, $
                   DO_LSTAR = do_lstar, PITCH = pitch, $
                   VERBOSE = VERBOSE 
      
    elapsed = systime(1)-now
    message, 'mag info compute time: '+varprt(elapsed/60.0)+' min', /info


    input_data.(new_idx).L(0) = lm
    IF do_lstar THEN FOR p = 0, n_elements(pa_idx)-1 DO $
          input_data.(new_idx).Lstar(pa_idx(p)) = lstar(*, p)
    input_data.(new_idx).mlt = mlt 
    input_data.(new_idx).mlat = mlat
    input_data.(new_idx).b1 = b1
    input_data.(new_idx).b2 = b2
    input_data.(new_idx).b3 = b3
    input_data.(new_idx).bmin = bmin


ENDFOR

error = 0 ;no errors to report

END
